/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.SimpleEmail;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.email.EmailManager;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskNotificationCondition;
import org.sonatype.nexus.scheduling.TaskNotificationMessageGenerator;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;

@Singleton
@Named
public class NexusTaskNotificationEmailSender
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final Provider<EmailManager> emailManager;
    private final Map<String, TaskNotificationMessageGenerator> taskNotificationMessageGenerators;

    @Inject
    public NexusTaskNotificationEmailSender(Provider<EmailManager> emailManager, Map<String, TaskNotificationMessageGenerator> taskNotificationMessageGenerators) {
        this.emailManager = (Provider)Preconditions.checkNotNull(emailManager);
        this.taskNotificationMessageGenerators = (Map)Preconditions.checkNotNull(taskNotificationMessageGenerators);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEventStoppedFailed event) {
        TaskInfo taskInfo = event.getTaskInfo();
        if (!this.haveAlertEmail(taskInfo)) {
            return;
        }
        String body = this.taskNotificationMessageGenerator(taskInfo.getTypeId()).failed(taskInfo, event.getFailureCause());
        this.log.trace("sending message {}", (Object)body);
        this.sendEmail("Task execution failure", taskInfo.getConfiguration().getAlertEmail(), body);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(TaskEventStoppedDone event) {
        TaskInfo taskInfo = event.getTaskInfo();
        if (!this.haveAlertEmail(taskInfo) || taskInfo.getConfiguration().getNotificationCondition() == TaskNotificationCondition.FAILURE) {
            return;
        }
        String body = this.taskNotificationMessageGenerator(taskInfo.getTypeId()).completed(taskInfo);
        this.log.trace("sending message {}", (Object)body);
        this.sendEmail("Task execution completed", taskInfo.getConfiguration().getAlertEmail(), body);
    }

    private boolean haveAlertEmail(TaskInfo taskInfo) {
        return taskInfo != null && taskInfo.getConfiguration().getAlertEmail() != null;
    }

    private void sendEmail(String subject, String address, String body) {
        try {
            SimpleEmail mail = new SimpleEmail();
            mail.setSubject(subject);
            mail.addTo(address);
            mail.setMsg(body);
            ((EmailManager)this.emailManager.get()).send((Email)mail);
        }
        catch (Exception e) {
            this.log.warn("Failed to send email", (Throwable)e);
        }
    }

    private TaskNotificationMessageGenerator taskNotificationMessageGenerator(String typeId) {
        TaskNotificationMessageGenerator result = this.taskNotificationMessageGenerators.get(typeId);
        if (result == null) {
            result = this.taskNotificationMessageGenerators.get("DEFAULT");
        }
        return result;
    }
}

