/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient.orient;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.internal.httpclient.AuthenticationConfigurationDeserializer;
import org.sonatype.nexus.internal.httpclient.AuthenticationConfigurationSerializer;
import org.sonatype.nexus.internal.httpclient.SecondsDeserializer;
import org.sonatype.nexus.internal.httpclient.SecondsSerializer;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfiguration;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfigurationCreatedEvent;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfigurationDeletedEvent;
import org.sonatype.nexus.internal.httpclient.orient.OrientHttpClientConfigurationUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class OrientHttpClientConfigurationEntityAdapter
extends SingletonEntityAdapter<OrientHttpClientConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("http_client").build();
    private final ObjectMapper objectMapper;
    private static final TypeReference<Map<String, Object>> MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};

    @Inject
    public OrientHttpClientConfigurationEntityAdapter(PasswordHelper passwordHelper) throws Exception {
        super(DB_CLASS);
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new SimpleModule().addSerializer(Time.class, (JsonSerializer)new SecondsSerializer()).addDeserializer(Time.class, (JsonDeserializer)new SecondsDeserializer()).addSerializer(AuthenticationConfiguration.class, (JsonSerializer)new AuthenticationConfigurationSerializer(passwordHelper)).addDeserializer(AuthenticationConfiguration.class, (JsonDeserializer)new AuthenticationConfigurationDeserializer(passwordHelper)));
    }

    protected void defineType(OClass type) {
    }

    protected OrientHttpClientConfiguration newEntity() {
        return new OrientHttpClientConfiguration();
    }

    protected void readFields(ODocument document, OrientHttpClientConfiguration entity) throws Exception {
        ObjectReader reader = this.objectMapper.readerForUpdating((Object)entity);
        TokenBuffer buff = new TokenBuffer((ObjectCodec)this.objectMapper, false);
        Map fields = document.toMap();
        fields.remove("@rid");
        fields.remove("@class");
        this.log.trace("Reading fields: {}", (Object)fields);
        this.objectMapper.writeValue((JsonGenerator)buff, (Object)fields);
        reader.readValue(buff.asParser());
    }

    protected void writeFields(ODocument document, OrientHttpClientConfiguration entity) throws Exception {
        Map fields = (Map)this.objectMapper.convertValue((Object)entity, MAP_STRING_OBJECT);
        this.log.trace("Writing fields: {}", (Object)fields);
        document.fromMap(fields);
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.debug("Emitted {} event with metadata {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case CREATE: {
                return new OrientHttpClientConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new OrientHttpClientConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientHttpClientConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

