/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient.orient;

import javax.annotation.Nullable;
import javax.validation.Valid;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.RedirectStrategy;
import org.sonatype.nexus.common.entity.AbstractEntity;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.ProxyConfiguration;

public class OrientHttpClientConfiguration
extends AbstractEntity
implements HttpClientConfiguration,
Cloneable {
    @Valid
    @Nullable
    private ConnectionConfiguration connection;
    @Valid
    @Nullable
    private ProxyConfiguration proxy;
    @Valid
    @Nullable
    private RedirectStrategy redirectStrategy;
    @Valid
    @Nullable
    private AuthenticationConfiguration authentication;
    @Valid
    @Nullable
    private AuthenticationStrategy authenticationStrategy;
    @Valid
    @Nullable
    private Boolean shouldNormalizeUri;
    @Valid
    @Nullable
    private Boolean disableContentCompression;

    OrientHttpClientConfiguration() {
    }

    @Nullable
    public ConnectionConfiguration getConnection() {
        return this.connection;
    }

    public void setConnection(@Nullable ConnectionConfiguration connection) {
        this.connection = connection;
    }

    @Nullable
    public ProxyConfiguration getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable ProxyConfiguration proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(@Nullable AuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    @Nullable
    public AuthenticationStrategy getAuthenticationStrategy() {
        return this.authenticationStrategy;
    }

    public void setAuthenticationStrategy(@Nullable AuthenticationStrategy authenticationStrategy) {
        this.authenticationStrategy = authenticationStrategy;
    }

    @Nullable
    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(@Nullable RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public Boolean getNormalizeUri() {
        return this.shouldNormalizeUri;
    }

    public void setNormalizeUri(Boolean normalizeUri) {
        this.shouldNormalizeUri = normalizeUri;
    }

    public Boolean getDisableContentCompression() {
        return this.disableContentCompression;
    }

    public void setDisableContentCompression(Boolean disableContentCompression) {
        this.disableContentCompression = disableContentCompression;
    }

    public OrientHttpClientConfiguration copy() {
        try {
            OrientHttpClientConfiguration copy = (OrientHttpClientConfiguration)this.clone();
            if (this.connection != null) {
                copy.connection = this.connection.copy();
            }
            if (this.proxy != null) {
                copy.proxy = this.proxy.copy();
            }
            if (this.authentication != null) {
                copy.authentication = this.authentication.copy();
            }
            if (this.redirectStrategy != null) {
                copy.redirectStrategy = this.redirectStrategy;
            }
            copy.shouldNormalizeUri = this.shouldNormalizeUri;
            copy.disableContentCompression = this.disableContentCompression;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "connection=" + this.connection + ", proxy=" + this.proxy + ", authentication=" + this.authentication + '}';
    }
}

