/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;

@Named
@Singleton
public class UserAgentGenerator
extends ComponentSupport {
    private final ApplicationVersion applicationVersion;
    private String value;
    private String edition;

    @Inject
    public UserAgentGenerator(ApplicationVersion applicationVersion) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
    }

    public String generate() {
        if (this.value == null || !this.applicationVersion.getEdition().equals(this.edition)) {
            this.edition = this.applicationVersion.getEdition();
            this.value = String.format("Nexus/%s (%s; %s; %s; %s; %s)", this.applicationVersion.getVersion(), this.edition, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"));
        }
        return this.value;
    }
}

