/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Time;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.nexus.common.app.ManagedLifecycleManager;
import org.sonatype.nexus.httpclient.SSLContextSelector;
import org.sonatype.nexus.internal.httpclient.ConnectionEvictionThread;
import org.sonatype.nexus.internal.httpclient.NexusSSLConnectionSocketFactory;

@Named(value="shared")
@Singleton
public class SharedHttpClientConnectionManager
extends PoolingHttpClientConnectionManager
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(SharedHttpClientConnectionManager.class);
    private final Time connectionPoolIdleTime;
    private final Time connectionPoolEvictingDelayTime;
    private ConnectionEvictionThread evictionThread;

    @Inject
    public SharedHttpClientConnectionManager(List<SSLContextSelector> sslContextSelectors, @Named(value="${nexus.httpclient.connectionpool.size:-20}") int connectionPoolSize, @Named(value="${nexus.httpclient.connectionpool.maxSize:-200}") int connectionPoolMaxSize, @Named(value="${nexus.httpclient.connectionpool.idleTime:-30s}") Time connectionPoolIdleTime, @Named(value="${nexus.httpclient.connectionpool.evictingDelayTime:-5s}") Time connectionPoolEvictingDelayTime, @Named(value="${nexus.httpclient.connectionpool.validateAfterInactivityTime:-2s}") Time connectionPoolValidateAfterInactivityTime, @Named(value="${nexus.httpclient.connectionpool.default.requestTimeout:-20s}") Time defaultSocketTimeout) {
        super((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator(SharedHttpClientConnectionManager.createRegistry(sslContextSelectors), null, null), null, connectionPoolIdleTime.toMillis(), TimeUnit.MILLISECONDS);
        this.setMaxTotal(connectionPoolMaxSize);
        log.debug("Connection pool max-size: {}", (Object)connectionPoolMaxSize);
        this.setDefaultMaxPerRoute(Math.min(connectionPoolSize, connectionPoolMaxSize));
        log.debug("Connection pool size: {}", (Object)connectionPoolSize);
        this.connectionPoolIdleTime = (Time)Preconditions.checkNotNull((Object)connectionPoolIdleTime);
        this.connectionPoolEvictingDelayTime = (Time)Preconditions.checkNotNull((Object)connectionPoolEvictingDelayTime);
        this.setValidateAfterInactivity(connectionPoolValidateAfterInactivityTime.toMillisI());
        log.debug("Connection pool idle-time: {}, evicting delay: {}, validate after inactivity: {}", new Object[]{connectionPoolIdleTime, connectionPoolEvictingDelayTime, connectionPoolValidateAfterInactivityTime});
        this.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(defaultSocketTimeout.toMillisI()).build());
        log.debug("Default socket timeout {}", (Object)defaultSocketTimeout);
    }

    private static Registry<ConnectionSocketFactory> createRegistry(List<SSLContextSelector> sslContextSelectors) {
        RegistryBuilder builder = RegistryBuilder.create();
        builder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        builder.register("https", (Object)new NexusSSLConnectionSocketFactory(sslContextSelectors));
        return builder.build();
    }

    public void shutdown() {
    }

    public void start() throws Exception {
        this.evictionThread = new ConnectionEvictionThread((HttpClientConnectionManager)this, this.connectionPoolIdleTime, this.connectionPoolEvictingDelayTime);
        this.evictionThread.start();
    }

    public void stop() throws Exception {
        this.evictionThread.interrupt();
        this.evictionThread = null;
        if (ManagedLifecycleManager.isShuttingDown()) {
            super.shutdown();
        }
    }
}

