/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.Subscribe;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.Mutex;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.internal.httpclient.DefaultsCustomizer;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationEvent;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationStore;
import org.sonatype.nexus.internal.httpclient.SharedHttpClientConnectionManager;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Priority(value=0x7FFFFFFF)
@Singleton
public class HttpClientManagerImpl
extends StateGuardLifecycleSupport
implements HttpClientManager,
EventAware {
    static final String HTTPCLIENT_OUTBOUND_LOGGER_NAME = "org.sonatype.nexus.httpclient.outbound";
    private static final String CTX_REQ_STOPWATCH = "request.stopwatch";
    private static final String CTX_REQ_URI = "request.uri";
    private final Logger outboundLog = LoggerFactory.getLogger((String)"org.sonatype.nexus.httpclient.outbound");
    private final EventManager eventManager;
    private final HttpClientConfigurationStore store;
    private final Provider<HttpClientConfiguration> defaults;
    private final SharedHttpClientConnectionManager sharedConnectionManager;
    private final DefaultsCustomizer defaultsCustomizer;
    private final Mutex lock = new Mutex();
    private HttpClientConfiguration configuration;

    @Inject
    public HttpClientManagerImpl(EventManager eventManager, HttpClientConfigurationStore store, @Named(value="initial") Provider<HttpClientConfiguration> defaults, SharedHttpClientConnectionManager sharedConnectionManager, DefaultsCustomizer defaultsCustomizer) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.store = (HttpClientConfigurationStore)Preconditions.checkNotNull((Object)store);
        this.log.debug("Store: {}", (Object)store);
        this.defaults = (Provider)Preconditions.checkNotNull(defaults);
        this.log.debug("Defaults: {}", defaults);
        this.sharedConnectionManager = (SharedHttpClientConnectionManager)((Object)Preconditions.checkNotNull((Object)((Object)sharedConnectionManager)));
        this.defaultsCustomizer = (DefaultsCustomizer)((Object)Preconditions.checkNotNull((Object)((Object)defaultsCustomizer)));
    }

    protected void doStart() throws Exception {
        this.sharedConnectionManager.start();
    }

    protected void doStop() throws Exception {
        this.sharedConnectionManager.stop();
    }

    private HttpClientConfiguration loadConfiguration() {
        HttpClientConfiguration model = this.store.load();
        if (model == null) {
            model = (HttpClientConfiguration)this.defaults.get();
            Preconditions.checkNotNull((Object)model);
            this.log.info("Using default configuration: {}", (Object)model);
        } else {
            this.log.info("Loaded configuration: {}", (Object)model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClientConfiguration getConfigurationInternal() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (this.configuration == null) {
                this.configuration = this.loadConfiguration();
            }
            return this.configuration;
        }
    }

    @Guarded(by={"STARTED"})
    public HttpClientConfiguration getConfiguration() {
        return this.getConfigurationInternal().copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Guarded(by={"STARTED"})
    public void setConfiguration(HttpClientConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        HttpClientConfiguration model = configuration.copy();
        this.log.info("Saving configuration: {}", (Object)model);
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.store.save(model);
            this.configuration = model;
        }
        this.eventManager.post((Object)new HttpClientConfigurationChangedEvent(model));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void onStoreChanged(HttpClientConfigurationEvent event) {
        if (!event.isLocal()) {
            HttpClientConfiguration model;
            this.log.debug("Reloading configuration after change by node {}", (Object)event.getRemoteNodeId());
            Mutex mutex = this.lock;
            synchronized (mutex) {
                this.configuration = model = this.loadConfiguration();
            }
            this.eventManager.post((Object)new HttpClientConfigurationChangedEvent(model));
        }
    }

    @Guarded(by={"STARTED"})
    public CloseableHttpClient create(@Nullable HttpClientPlan.Customizer customizer) {
        return this.prepare(customizer).build();
    }

    @Guarded(by={"STARTED"})
    public CloseableHttpClient create() {
        return this.create(null);
    }

    @Guarded(by={"STARTED"})
    public HttpClientBuilder prepare(@Nullable HttpClientPlan.Customizer customizer) {
        HttpClientPlan plan = this.httpClientPlan();
        plan.getClient().setConnectionManager((HttpClientConnectionManager)this.sharedConnectionManager);
        this.defaultsCustomizer.customize(plan);
        new ConfigurationCustomizer(this.getConfigurationInternal()).customize(plan);
        if (customizer != null) {
            customizer.customize(plan);
        }
        HttpClientBuilder builder = plan.getClient();
        String userAgent = plan.getUserAgent();
        if (userAgent != null) {
            this.setUserAgent(builder, userAgent);
        }
        builder.setDefaultConnectionConfig(plan.getConnection().build());
        builder.setDefaultSocketConfig(plan.getSocket().build());
        builder.setDefaultRequestConfig(plan.getRequest().build());
        builder.setDefaultCredentialsProvider(plan.getCredentials());
        builder.addInterceptorFirst((request, context) -> {
            for (Map.Entry entry : plan.getAttributes().entrySet()) {
                if (context.getAttribute((String)entry.getKey()) != null) continue;
                context.setAttribute((String)entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : plan.getHeaders().entrySet()) {
                request.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        builder.addInterceptorLast((httpRequest, httpContext) -> {
            if (this.outboundLog.isDebugEnabled()) {
                httpContext.setAttribute(CTX_REQ_STOPWATCH, (Object)Stopwatch.createStarted());
                httpContext.setAttribute(CTX_REQ_URI, (Object)this.getRequestURI(httpContext));
                this.outboundLog.debug("{} > {}", httpContext.getAttribute(CTX_REQ_URI), (Object)httpRequest.getRequestLine());
            }
        });
        builder.addInterceptorLast((httpResponse, httpContext) -> {
            Stopwatch stopwatch = (Stopwatch)httpContext.getAttribute(CTX_REQ_STOPWATCH);
            if (stopwatch != null) {
                this.outboundLog.debug("{} < {} @ {}", new Object[]{httpContext.getAttribute(CTX_REQ_URI), httpResponse.getStatusLine(), stopwatch});
            }
        });
        return builder;
    }

    public HttpClientConfiguration newConfiguration() {
        return this.store.newConfiguration();
    }

    @VisibleForTesting
    void setUserAgent(HttpClientBuilder builder, String value) {
        builder.setUserAgent(value);
    }

    @VisibleForTesting
    HttpClientPlan httpClientPlan() {
        return new HttpClientPlan();
    }

    @Nonnull
    private URI getRequestURI(HttpContext context) {
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest httpRequest = clientContext.getRequest();
        HttpHost target = clientContext.getTargetHost();
        try {
            URI uri = httpRequest instanceof HttpUriRequest ? ((HttpUriRequest)httpRequest).getURI() : URI.create(httpRequest.getRequestLine().getUri());
            return uri.isAbsolute() ? uri : URIUtils.resolve((URI)URI.create(target.toURI()), (URI)uri);
        }
        catch (Exception e) {
            this.log.warn("Could not create absolute request URI", (Throwable)e);
            return URI.create(target.toURI());
        }
    }
}

