/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationDAO;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationData;
import org.sonatype.nexus.internal.httpclient.HttpClientConfigurationStore;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class HttpClientConfigurationStoreImpl
extends ConfigStoreSupport<HttpClientConfigurationDAO>
implements HttpClientConfigurationStore {
    @Inject
    public HttpClientConfigurationStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public HttpClientConfiguration newConfiguration() {
        return new HttpClientConfigurationData();
    }

    @Override
    @Transactional
    public HttpClientConfiguration load() {
        return ((HttpClientConfigurationDAO)this.dao()).get().orElse(null);
    }

    @Override
    @Transactional
    public void save(HttpClientConfiguration configuration) {
        ((HttpClientConfigurationDAO)this.dao()).set((HttpClientConfigurationData)configuration);
    }
}

