/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.sonatype.goodies.common.ByteSize;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.internal.httpclient.NexusConnectionKeepAliveStrategy;
import org.sonatype.nexus.internal.httpclient.UserAgentGenerator;

@Named
@Singleton
public class DefaultsCustomizer
extends ComponentSupport
implements HttpClientPlan.Customizer {
    private final UserAgentGenerator userAgentGenerator;
    private final Time requestTimeout;
    private final Time connectionRequestTimeout;
    private final Time keepAliveDuration;
    private final ByteSize bufferSize;

    @Inject
    public DefaultsCustomizer(UserAgentGenerator userAgentGenerator, @Named(value="${nexus.httpclient.requestTimeout:-20s}") Time requestTimeout, @Named(value="${nexus.httpclient.connectionRequestTimeout:-30s}") Time connectionRequestTimeout, @Named(value="${nexus.httpclient.keepAliveDuration:-30s}") Time keepAliveDuration, @Named(value="${nexus.httpclient.bufferSize:-8k}") ByteSize bufferSize) {
        this.userAgentGenerator = (UserAgentGenerator)((Object)Preconditions.checkNotNull((Object)((Object)userAgentGenerator)));
        this.requestTimeout = (Time)Preconditions.checkNotNull((Object)requestTimeout);
        this.log.debug("Request timeout: {}", (Object)requestTimeout);
        this.connectionRequestTimeout = (Time)Preconditions.checkNotNull((Object)connectionRequestTimeout);
        this.log.debug("Connection request timeout: {}", (Object)connectionRequestTimeout);
        this.keepAliveDuration = (Time)Preconditions.checkNotNull((Object)keepAliveDuration);
        this.log.debug("Keep-alive duration: {}", (Object)keepAliveDuration);
        this.bufferSize = (ByteSize)Preconditions.checkNotNull((Object)bufferSize);
        this.log.debug("Buffer-size: {}", (Object)bufferSize);
    }

    public void customize(HttpClientPlan plan) {
        Preconditions.checkNotNull((Object)plan);
        plan.setUserAgentBase(this.userAgentGenerator.generate());
        plan.getClient().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new NexusConnectionKeepAliveStrategy(this.keepAliveDuration.toMillis()));
        plan.getClient().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(2, false));
        plan.getConnection().setBufferSize(this.bufferSize.toBytesI());
        plan.getRequest().setConnectionRequestTimeout(this.connectionRequestTimeout.toMillisI());
        plan.getRequest().setCookieSpec("ignoreCookies");
        plan.getRequest().setExpectContinueEnabled(false);
        int requestTimeoutMillis = this.requestTimeout.toMillisI();
        plan.getSocket().setSoTimeout(requestTimeoutMillis);
        plan.getRequest().setConnectTimeout(requestTimeoutMillis);
        plan.getRequest().setSocketTimeout(requestTimeoutMillis);
    }
}

