/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.BearerTokenAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;
import org.sonatype.nexus.security.PasswordHelper;

public class AuthenticationConfigurationSerializer
extends StdSerializer<AuthenticationConfiguration> {
    private final PasswordHelper passwordHelper;

    public AuthenticationConfigurationSerializer(PasswordHelper passwordHelper) {
        super(AuthenticationConfiguration.class);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    public void serialize(AuthenticationConfiguration value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.serialize(value, jgen);
        jgen.writeEndObject();
    }

    public void serializeWithType(AuthenticationConfiguration value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(value, jgen);
        if (value instanceof UsernameAuthenticationConfiguration) {
            jgen.writeStringField(typeSer.getPropertyName(), "username");
        } else if (value instanceof NtlmAuthenticationConfiguration) {
            jgen.writeStringField(typeSer.getPropertyName(), "ntlm");
        } else if (value instanceof BearerTokenAuthenticationConfiguration) {
            jgen.writeStringField(typeSer.getPropertyName(), "bearerToken");
        } else {
            throw new JsonGenerationException("Unsupported type:" + value.getClass().getName(), jgen);
        }
        jgen.writeEndObject();
    }

    private void serialize(AuthenticationConfiguration value, JsonGenerator jgen) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("type", value.getType());
        jgen.writeBooleanField("preemptive", value.isPreemptive());
        if (value instanceof UsernameAuthenticationConfiguration) {
            UsernameAuthenticationConfiguration upc = (UsernameAuthenticationConfiguration)value;
            jgen.writeStringField("username", upc.getUsername());
            jgen.writeStringField("password", this.passwordHelper.encrypt(upc.getPassword()));
        } else if (value instanceof NtlmAuthenticationConfiguration) {
            NtlmAuthenticationConfiguration ntc = (NtlmAuthenticationConfiguration)value;
            jgen.writeStringField("username", ntc.getUsername());
            jgen.writeStringField("password", this.passwordHelper.encrypt(ntc.getPassword()));
            jgen.writeStringField("domain", ntc.getDomain());
            jgen.writeStringField("host", ntc.getHost());
        } else if (value instanceof BearerTokenAuthenticationConfiguration) {
            BearerTokenAuthenticationConfiguration btac = (BearerTokenAuthenticationConfiguration)value;
            jgen.writeStringField("bearerToken", this.passwordHelper.encrypt(btac.getBearerToken()));
        } else {
            throw new JsonGenerationException("Unsupported type:" + value.getClass().getName());
        }
    }
}

