/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.httpclient;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.BearerTokenAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.NtlmAuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;
import org.sonatype.nexus.security.PasswordHelper;

public class AuthenticationConfigurationDeserializer
extends StdDeserializer<AuthenticationConfiguration> {
    private final PasswordHelper passwordHelper;

    public AuthenticationConfigurationDeserializer(PasswordHelper passwordHelper) {
        super(AuthenticationConfiguration.class);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    public AuthenticationConfiguration deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        return this.deserialize(parser);
    }

    public AuthenticationConfiguration deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(parser);
    }

    private AuthenticationConfiguration deserialize(JsonParser parser) throws IOException {
        JsonNode node = (JsonNode)parser.readValueAsTree();
        String typeName = node.get("type").textValue();
        Class type = (Class)AuthenticationConfiguration.TYPES.get(typeName);
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Unknown %s type: %s", (Object)AuthenticationConfiguration.class.getSimpleName(), (Object)typeName);
        AuthenticationConfiguration configuration = (AuthenticationConfiguration)parser.getCodec().treeToValue((TreeNode)node, type);
        configuration.setPreemptive(configuration.isPreemptive());
        if (UsernameAuthenticationConfiguration.class.equals((Object)type)) {
            UsernameAuthenticationConfiguration upc = (UsernameAuthenticationConfiguration)configuration;
            upc.setUsername(upc.getUsername());
            upc.setPassword(this.passwordHelper.tryDecrypt(upc.getPassword()));
        } else if (NtlmAuthenticationConfiguration.class.equals((Object)type)) {
            NtlmAuthenticationConfiguration ntc = (NtlmAuthenticationConfiguration)configuration;
            ntc.setUsername(ntc.getUsername());
            ntc.setPassword(this.passwordHelper.tryDecrypt(ntc.getPassword()));
            ntc.setDomain(ntc.getDomain());
            ntc.setHost(ntc.getHost());
        } else if (BearerTokenAuthenticationConfiguration.class.equals((Object)type)) {
            BearerTokenAuthenticationConfiguration btac = (BearerTokenAuthenticationConfiguration)configuration;
            btac.setBearerToken(this.passwordHelper.tryDecrypt(btac.getBearerToken()));
        }
        return configuration;
    }
}

