/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfiguration;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfigurationCreatedEvent;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfigurationDeletedEvent;
import org.sonatype.nexus.internal.email.orient.OrientEmailConfigurationUpdatedEvent;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class OrientEmailConfigurationEntityAdapter
extends SingletonEntityAdapter<OrientEmailConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("email").build();
    private static final String P_ENABLED = "enabled";
    private static final String P_HOST = "host";
    private static final String P_PORT = "port";
    private static final String P_USERNAME = "username";
    private static final String P_PASSWORD = "password";
    private static final String P_FROM_ADDRESS = "from_address";
    private static final String P_SUBJECT_PREFIX = "subject_prefix";
    private static final String P_START_TLS_ENABLED = "start_tls_enabled";
    private static final String P_START_TLS_REQUIRED = "start_tls_required";
    private static final String P_SSL_ON_CONNECT_ENABLED = "ssl_on_connect_enabled";
    private static final String P_SSL_CHECK_SERVER_IDENTITY_ENABLED = "ssl_check_server_identity_enabled";
    private static final String P_NEXUS_TRUST_STORE_ENABLED = "nexus_trust_store_enabled";
    private final PasswordHelper passwordHelper;

    @Inject
    public OrientEmailConfigurationEntityAdapter(PasswordHelper passwordHelper) throws Exception {
        super(DB_CLASS);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ENABLED, OType.BOOLEAN);
        type.createProperty(P_HOST, OType.STRING);
        type.createProperty(P_PORT, OType.INTEGER);
        type.createProperty(P_USERNAME, OType.STRING);
        type.createProperty(P_PASSWORD, OType.STRING);
        type.createProperty(P_FROM_ADDRESS, OType.STRING);
        type.createProperty(P_SUBJECT_PREFIX, OType.STRING);
        type.createProperty(P_START_TLS_ENABLED, OType.BOOLEAN);
        type.createProperty(P_START_TLS_REQUIRED, OType.BOOLEAN);
        type.createProperty(P_SSL_ON_CONNECT_ENABLED, OType.BOOLEAN);
        type.createProperty(P_SSL_CHECK_SERVER_IDENTITY_ENABLED, OType.BOOLEAN);
        type.createProperty(P_NEXUS_TRUST_STORE_ENABLED, OType.BOOLEAN);
    }

    protected OrientEmailConfiguration newEntity() {
        return new OrientEmailConfiguration();
    }

    protected void readFields(ODocument document, OrientEmailConfiguration entity) {
        boolean enabled = (Boolean)document.field(P_ENABLED, OType.BOOLEAN);
        String host = (String)document.field(P_HOST, OType.STRING);
        int port = (Integer)document.field(P_PORT, OType.INTEGER);
        String username = (String)document.field(P_USERNAME, OType.STRING);
        String password = (String)document.field(P_PASSWORD, OType.STRING);
        String fromAddress = (String)document.field(P_FROM_ADDRESS, OType.STRING);
        String subjectPrefix = (String)document.field(P_SUBJECT_PREFIX, OType.STRING);
        boolean startTlsEnabled = (Boolean)document.field(P_START_TLS_ENABLED, OType.BOOLEAN);
        boolean startTlsRequired = (Boolean)document.field(P_START_TLS_REQUIRED, OType.BOOLEAN);
        boolean sslOnConnectEnabled = (Boolean)document.field(P_SSL_ON_CONNECT_ENABLED, OType.BOOLEAN);
        boolean sslCheckServerIdentityEnabled = (Boolean)document.field(P_SSL_CHECK_SERVER_IDENTITY_ENABLED, OType.BOOLEAN);
        boolean nexusTrustStoreEnabled = (Boolean)document.field(P_NEXUS_TRUST_STORE_ENABLED, OType.BOOLEAN);
        entity.setEnabled(enabled);
        entity.setHost(host);
        entity.setPort(port);
        entity.setUsername(username);
        entity.setPassword(this.passwordHelper.tryDecrypt(password));
        entity.setFromAddress(fromAddress);
        entity.setSubjectPrefix(subjectPrefix);
        entity.setStartTlsEnabled(startTlsEnabled);
        entity.setStartTlsRequired(startTlsRequired);
        entity.setSslOnConnectEnabled(sslOnConnectEnabled);
        entity.setSslCheckServerIdentityEnabled(sslCheckServerIdentityEnabled);
        entity.setNexusTrustStoreEnabled(nexusTrustStoreEnabled);
    }

    protected void writeFields(ODocument document, OrientEmailConfiguration entity) {
        document.field(P_ENABLED, (Object)entity.isEnabled());
        document.field(P_HOST, (Object)entity.getHost());
        document.field(P_PORT, (Object)entity.getPort());
        document.field(P_USERNAME, (Object)entity.getUsername());
        document.field(P_PASSWORD, (Object)this.passwordHelper.encrypt(entity.getPassword()));
        document.field(P_FROM_ADDRESS, (Object)entity.getFromAddress());
        document.field(P_SUBJECT_PREFIX, (Object)entity.getSubjectPrefix());
        document.field(P_START_TLS_ENABLED, (Object)entity.isStartTlsEnabled());
        document.field(P_START_TLS_REQUIRED, (Object)entity.isStartTlsRequired());
        document.field(P_SSL_ON_CONNECT_ENABLED, (Object)entity.isSslOnConnectEnabled());
        document.field(P_SSL_CHECK_SERVER_IDENTITY_ENABLED, (Object)entity.isSslCheckServerIdentityEnabled());
        document.field(P_NEXUS_TRUST_STORE_ENABLED, (Object)entity.isNexusTrustStoreEnabled());
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.debug("Emitted {} event with metadata {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case CREATE: {
                return new OrientEmailConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new OrientEmailConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new OrientEmailConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

