/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.internal.email.EmailConfigurationStore;
import org.sonatype.nexus.internal.email.MemoryEmailConfiguration;

@Named(value="memory")
@Singleton
@Priority(value=-2147483648)
@VisibleForTesting
public class MemoryEmailConfigurationStore
extends ComponentSupport
implements EmailConfigurationStore {
    private EmailConfiguration model;

    @Override
    @Nullable
    public synchronized EmailConfiguration load() {
        return this.model;
    }

    @Override
    public synchronized void save(EmailConfiguration configuration) {
        this.model = (EmailConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public EmailConfiguration newConfiguration() {
        return new MemoryEmailConfiguration();
    }
}

