/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.internal.email.EmailConfigurationData;
import org.sonatype.nexus.internal.email.EmailConfigurationStore;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="emailConfigurationExport")
@Singleton
public class EmailConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final EmailConfigurationStore store;

    @Inject
    public EmailConfigurationExport(EmailConfigurationStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export EmailConfiguration data to {}", (Object)file);
        EmailConfiguration configuration = this.store.load();
        this.exportObjectToJson(configuration, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring EmailConfiguration data from {}", (Object)file);
        Optional configuration = this.importObjectFromJson(file, EmailConfigurationData.class);
        configuration.ifPresent(this.store::save);
    }
}

