/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.email;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.email.EmailConfigurationChangedEvent;

@Named
@Singleton
public class EmailAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "email";

    @Subscribe
    @AllowConcurrentEvents
    public void on(EmailConfigurationChangedEvent event) {
        if (this.isRecording()) {
            EmailConfiguration configuration = event.getConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("changed");
            data.setContext("system");
            Map attributes = data.getAttributes();
            attributes.put("enabled", EmailAuditor.string((Object)configuration.isEnabled()));
            attributes.put("host", configuration.getHost());
            attributes.put("port", EmailAuditor.string((Object)configuration.getPort()));
            attributes.put("username", configuration.getUsername());
            attributes.put("fromAddress", configuration.getFromAddress());
            attributes.put("subjectPrefix", configuration.getSubjectPrefix());
            this.record(data);
        }
    }
}

