/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.datastore.task;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class H2BackupTask
extends TaskSupport {
    private final DataStoreManager dataStoreManager;
    private final ApplicationDirectories applicationDirectories;
    private static final String TIMESTAMP_FORMAT = "%1$tY-%1$tm-%1$td-%1$tH-%1$tM-%1$tS";

    @Inject
    public H2BackupTask(DataStoreManager dataStoreManager, ApplicationDirectories applicationDirectories) {
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    public String getMessage() {
        return "Backup embedded h2 database to the specified location";
    }

    protected Object execute() throws Exception {
        Optional dataStore = this.dataStoreManager.get("nexus");
        if (!dataStore.isPresent()) {
            throw new RuntimeException("Unable to locate datastore with name nexus");
        }
        File backupFolder = this.applicationDirectories.getWorkDirectory((String)Preconditions.checkNotNull((Object)this.getConfiguration().getString("location"), (Object)"Backup location not configured"));
        File backupFile = new File(backupFolder, this.getBackupFileName());
        if (backupFile.isFile()) {
            throw new IOException("File already exists at backup file location: " + backupFile.getAbsolutePath());
        }
        this.log.info("Starting backup of {} to {}", (Object)"nexus", (Object)backupFile.getAbsolutePath());
        long start = System.currentTimeMillis();
        ((DataStore)dataStore.get()).backup(backupFile.getAbsolutePath());
        this.log.info("Completed backup of {} in {} ms", (Object)"nexus", (Object)(System.currentTimeMillis() - start));
        return null;
    }

    private String getBackupFileName() {
        return "nexus-" + String.format(TIMESTAMP_FORMAT, LocalDateTime.now()) + ".zip";
    }
}

