/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;
import org.sonatype.nexus.common.entity.HasEntityId;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemDAO;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemData;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CapabilityStorageImpl
extends ConfigStoreSupport<CapabilityStorageItemDAO>
implements CapabilityStorage {
    @Inject
    public CapabilityStorageImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public CapabilityStorageItem newStorageItem(int version, String type, boolean enabled, String notes, Map<String, String> properties) {
        CapabilityStorageItemData item = new CapabilityStorageItemData();
        item.setVersion(version);
        item.setType(type);
        item.setEnabled(enabled);
        item.setNotes(notes);
        item.setProperties(properties);
        return item;
    }

    @Override
    @Transactional
    public CapabilityIdentity add(CapabilityStorageItem item) {
        ((CapabilityStorageItemDAO)this.dao()).create((CapabilityStorageItemData)item);
        return this.capabilityIdentity(item);
    }

    @Override
    @Transactional
    public boolean update(CapabilityIdentity id, CapabilityStorageItem item) {
        ((HasEntityId)item).setId(this.entityId(id));
        return ((CapabilityStorageItemDAO)this.dao()).update((CapabilityStorageItemData)item);
    }

    @Override
    @Transactional
    public boolean remove(CapabilityIdentity id) {
        return ((CapabilityStorageItemDAO)this.dao()).delete(this.entityId(id));
    }

    @Override
    @Transactional
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() {
        return (Map)Streams.stream((Iterable)((CapabilityStorageItemDAO)this.dao()).browse()).collect(ImmutableMap.toImmutableMap(this::capabilityIdentity, Function.identity()));
    }

    private CapabilityIdentity capabilityIdentity(CapabilityStorageItem item) {
        return new CapabilityIdentity(((HasEntityId)item).getId().getValue());
    }

    private EntityId entityId(CapabilityIdentity id) {
        return new EntityUUID(UUID.fromString(id.toString()));
    }
}

