/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.node;

import com.google.common.base.Preconditions;
import java.security.cert.Certificate;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.node.orient.OrientNodeAccess;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.internal.capability.node.IdentityCapabilityConfiguration;
import org.sonatype.nexus.ssl.CertificateUtil;

@FeatureFlag(name="nexus.orient.enabled")
@Named(value="node.identity")
public class OrientIdentityCapability
extends CapabilitySupport<IdentityCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final OrientNodeAccess nodeAccess;

    @Inject
    public OrientIdentityCapability(OrientNodeAccess nodeAccess) {
        this.nodeAccess = (OrientNodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected IdentityCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new IdentityCapabilityConfiguration(properties);
    }

    protected String renderDescription() throws Exception {
        return messages.description(this.nodeAccess.getId());
    }

    protected String renderStatus() throws Exception {
        return this.render("node.identity-status.vm", new TemplateParameters().set("nodeId", (Object)this.nodeAccess.getId()).set("fingerprint", (Object)this.nodeAccess.getFingerprint()).set("pem", (Object)CertificateUtil.serializeCertificateInPEM((Certificate)this.nodeAccess.getCertificate())).set("detail", (Object)this.nodeAccess.getCertificate().toString()));
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="%s")
        public String description(String var1);
    }
}

