/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability.node;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.internal.capability.node.IdentityCapabilityConfiguration;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="node.identity")
public class IdentityCapability
extends CapabilitySupport<IdentityCapabilityConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final NodeAccess nodeAccess;

    @Inject
    public IdentityCapability(NodeAccess nodeAccess) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected IdentityCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new IdentityCapabilityConfiguration(properties);
    }

    protected String renderDescription() throws Exception {
        return messages.description(this.nodeAccess.getId());
    }

    protected String renderStatus() throws Exception {
        return this.render("node.identity-status.vm", new TemplateParameters().set("nodeId", (Object)this.nodeAccess.getId()));
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="%s")
        public String description(String var1);
    }
}

