/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.Capability;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityFactory;
import org.sonatype.nexus.capability.CapabilityFactoryRegistry;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.capability.CapabilityNotFoundException;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityRegistryEvent;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.formfields.Encrypted;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.internal.capability.ActivationConditionHandlerFactory;
import org.sonatype.nexus.internal.capability.DefaultCapabilityReference;
import org.sonatype.nexus.internal.capability.ValidityConditionHandlerFactory;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorage;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItem;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemCreatedEvent;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemDeletedEvent;
import org.sonatype.nexus.internal.capability.storage.CapabilityStorageItemUpdatedEvent;
import org.sonatype.nexus.security.PasswordHelper;

@Singleton
@Named
public class DefaultCapabilityRegistry
extends ComponentSupport
implements CapabilityRegistry,
EventAware,
EventAware.Asynchronous {
    private final CapabilityStorage capabilityStorage;
    private final CapabilityFactoryRegistry capabilityFactoryRegistry;
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;
    private final EventManager eventManager;
    private final ActivationConditionHandlerFactory activationConditionHandlerFactory;
    private final ValidityConditionHandlerFactory validityConditionHandlerFactory;
    private final PasswordHelper passwordHelper;
    private final Provider<Validator> validatorProvider;
    private final Map<CapabilityIdentity, DefaultCapabilityReference> references;
    private final ReentrantReadWriteLock lock;

    @Inject
    DefaultCapabilityRegistry(CapabilityStorage capabilityStorage, CapabilityFactoryRegistry capabilityFactoryRegistry, CapabilityDescriptorRegistry capabilityDescriptorRegistry, EventManager eventManager, ActivationConditionHandlerFactory activationConditionHandlerFactory, ValidityConditionHandlerFactory validityConditionHandlerFactory, PasswordHelper passwordHelper, Provider<Validator> validatorProvider) {
        this.capabilityStorage = (CapabilityStorage)Preconditions.checkNotNull((Object)capabilityStorage);
        this.capabilityFactoryRegistry = (CapabilityFactoryRegistry)Preconditions.checkNotNull((Object)capabilityFactoryRegistry);
        this.capabilityDescriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)capabilityDescriptorRegistry);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.activationConditionHandlerFactory = (ActivationConditionHandlerFactory)Preconditions.checkNotNull((Object)activationConditionHandlerFactory);
        this.validityConditionHandlerFactory = (ValidityConditionHandlerFactory)Preconditions.checkNotNull((Object)validityConditionHandlerFactory);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.validatorProvider = (Provider)Preconditions.checkNotNull(validatorProvider);
        this.references = new HashMap<CapabilityIdentity, DefaultCapabilityReference>();
        this.lock = new ReentrantReadWriteLock();
    }

    public CapabilityReference add(CapabilityType type, boolean enabled, @Nullable String notes, @Nullable Map<String, String> properties) {
        Preconditions.checkNotNull((Object)type);
        try {
            this.lock.writeLock().lock();
            Map<Object, Object> props = properties == null ? Maps.newHashMap() : properties;
            ((Validator)this.validatorProvider.get()).validate((Object)type, new Class[0]);
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(type);
            descriptor.validate(null, (Map)props, CapabilityDescriptor.ValidationMode.CREATE);
            Map<String, String> encryptedProps = this.encryptValuesIfNeeded(descriptor, props);
            CapabilityStorageItem item = this.capabilityStorage.newStorageItem(descriptor.version(), type.toString(), enabled, notes, encryptedProps);
            CapabilityIdentity generatedId = this.capabilityStorage.add(item);
            CapabilityReference capabilityReference = this.doAdd(generatedId, type, descriptor, item, props);
            return capabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Subscribe
    public void on(CapabilityStorageItemCreatedEvent event) {
        if (!event.isLocal()) {
            CapabilityIdentity id = event.getCapabilityId();
            CapabilityStorageItem item = event.getCapabilityStorageItem();
            CapabilityType type = CapabilityType.capabilityType((String)item.getType());
            try {
                this.lock.writeLock().lock();
                CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(type);
                Map<String, String> decryptedProps = this.decryptValuesIfNeeded(descriptor, item.getProperties());
                this.doAdd(id, type, descriptor, item, decryptedProps);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private CapabilityReference doAdd(CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor, CapabilityStorageItem item, @Nullable Map<String, String> decryptedProps) {
        this.log.debug("Added capability '{}' of type '{}' with properties '{}'", new Object[]{id, type, item.getProperties()});
        DefaultCapabilityReference reference = this.create(id, type, descriptor);
        reference.setNotes(item.getNotes());
        reference.create(decryptedProps);
        if (item.isEnabled()) {
            reference.enable();
            reference.activate();
        }
        return reference;
    }

    public CapabilityReference update(CapabilityIdentity id, boolean enabled, @Nullable String notes, @Nullable Map<String, String> properties) {
        try {
            this.lock.writeLock().lock();
            Map<Object, Object> props = properties == null ? Maps.newHashMap() : properties;
            this.validateId(id);
            DefaultCapabilityReference reference = this.get(id);
            reference.descriptor().validate(id, (Map)props, CapabilityDescriptor.ValidationMode.UPDATE);
            Map<String, String> encryptedProps = this.encryptValuesIfNeeded(reference.descriptor(), props);
            CapabilityStorageItem item = this.capabilityStorage.newStorageItem(reference.descriptor().version(), reference.type().toString(), enabled, notes, encryptedProps);
            this.capabilityStorage.update(id, item);
            CapabilityReference capabilityReference = this.doUpdate(reference, item, props);
            return capabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Subscribe
    public void on(CapabilityStorageItemUpdatedEvent event) {
        if (!event.isLocal()) {
            CapabilityIdentity id = event.getCapabilityId();
            CapabilityStorageItem item = event.getCapabilityStorageItem();
            try {
                this.lock.writeLock().lock();
                DefaultCapabilityReference reference = this.get(id);
                Map<String, String> decryptedProps = this.decryptValuesIfNeeded(reference.descriptor(), item.getProperties());
                this.doUpdate(reference, item, decryptedProps);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private CapabilityReference doUpdate(DefaultCapabilityReference reference, CapabilityStorageItem item, @Nullable Map<String, String> decryptedProps) {
        this.log.debug("Updated capability '{}' of type '{}' with properties '{}'", new Object[]{reference.id(), reference.type(), item.getProperties()});
        if (reference.isEnabled() && !item.isEnabled()) {
            reference.disable();
        }
        reference.setNotes(item.getNotes());
        reference.update(decryptedProps, reference.properties());
        if (!reference.isEnabled() && item.isEnabled()) {
            reference.enable();
            reference.activate();
        }
        return reference;
    }

    public CapabilityReference remove(CapabilityIdentity id) {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            this.capabilityStorage.remove(id);
            CapabilityReference capabilityReference = this.doRemove(id);
            return capabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Subscribe
    public void on(CapabilityStorageItemDeletedEvent event) {
        if (!event.isLocal()) {
            CapabilityIdentity id = event.getCapabilityId();
            try {
                this.lock.writeLock().lock();
                this.doRemove(id);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private CapabilityReference doRemove(CapabilityIdentity id) {
        this.log.debug("Removed capability '{}'", (Object)id);
        DefaultCapabilityReference reference = this.references.remove(id);
        if (reference != null) {
            reference.remove();
        }
        return reference;
    }

    public CapabilityReference enable(CapabilityIdentity id) {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            DefaultCapabilityReference reference = this.get(id);
            CapabilityReference capabilityReference = this.update(reference.context().id(), true, reference.notes(), reference.properties());
            return capabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CapabilityReference disable(CapabilityIdentity id) {
        try {
            this.lock.writeLock().lock();
            this.validateId(id);
            DefaultCapabilityReference reference = this.get(id);
            CapabilityReference capabilityReference = this.update(reference.context().id(), false, reference.notes(), reference.properties());
            return capabilityReference;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DefaultCapabilityReference get(CapabilityIdentity id) {
        try {
            this.lock.readLock().lock();
            DefaultCapabilityReference defaultCapabilityReference = this.references.get(id);
            return defaultCapabilityReference;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Collection<DefaultCapabilityReference> get(Predicate<CapabilityReference> filter) {
        return Collections.unmodifiableCollection(Collections2.filter(this.getAll(), filter));
    }

    public Collection<DefaultCapabilityReference> getAll() {
        try {
            this.lock.readLock().lock();
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.references.values());
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void load() {
        Map<CapabilityIdentity, CapabilityStorageItem> items = this.capabilityStorage.getAll();
        for (Map.Entry<CapabilityIdentity, CapabilityStorageItem> entry : items.entrySet()) {
            DefaultCapabilityReference reference;
            CapabilityIdentity id = entry.getKey();
            CapabilityStorageItem item = entry.getValue();
            this.log.debug("Loading capability '{}' of type '{}' with properties '{}'", new Object[]{id, item.getType(), item.getProperties()});
            CapabilityDescriptor descriptor = this.capabilityDescriptorRegistry.get(CapabilityType.capabilityType((String)item.getType()));
            if (descriptor == null) {
                this.log.warn("Capabilities persistent storage contains a capability of unknown type {} with id {}. This capability will not be loaded", (Object)item.getType(), (Object)id);
                continue;
            }
            Map<String, String> properties = this.decryptValuesIfNeeded(descriptor, item.getProperties());
            if (descriptor.version() != item.getVersion()) {
                block9: {
                    this.log.debug("Converting capability '{}' properties from version '{}' to version '{}'", new Object[]{id, item.getVersion(), descriptor.version()});
                    try {
                        properties = descriptor.convert(properties, item.getVersion());
                        if (properties == null) {
                            properties = Collections.emptyMap();
                        }
                        if (!this.log.isDebugEnabled()) break block9;
                        this.log.debug("Converted capability '{}' properties '{}' (version '{}') to '{}' (version '{}')", new Object[]{id, item.getProperties(), item.getVersion(), this.encryptValuesIfNeeded(descriptor, properties), descriptor.version()});
                    }
                    catch (Exception e) {
                        this.log.error("Failed converting capability '{}' properties '{}' from version '{}' to version '{}'. Capability will not be loaded", new Object[]{id, item.getProperties(), item.getVersion(), descriptor.version(), e});
                        continue;
                    }
                }
                this.capabilityStorage.update(id, this.capabilityStorage.newStorageItem(descriptor.version(), item.getType(), item.isEnabled(), item.getNotes(), properties));
            }
            if ((reference = this.references.get(id)) != null) {
                this.doUpdate(reference, item, properties);
                continue;
            }
            reference = this.create(id, CapabilityType.capabilityType((String)item.getType()), descriptor);
            reference.setNotes(item.getNotes());
            reference.load(properties);
            try {
                reference.descriptor().validate(id, (Map)properties, CapabilityDescriptor.ValidationMode.LOAD);
            }
            catch (ValidationException e) {
                this.log.warn("Capability '{}' of type '{}' with properties '{}' is invalid", new Object[]{id, item.getType(), item.getProperties(), e});
                reference.setFailure("Load", (Exception)((Object)e));
            }
            if (!item.isEnabled()) continue;
            reference.enable();
            reference.activate();
        }
        this.eventManager.post((Object)new CapabilityRegistryEvent.AfterLoad((CapabilityRegistry)this));
    }

    private DefaultCapabilityReference create(CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor) {
        CapabilityFactory factory = this.capabilityFactoryRegistry.get(type);
        if (factory == null) {
            throw new RuntimeException(String.format("No factory found for a capability of type %s", type));
        }
        Capability capability = factory.create();
        DefaultCapabilityReference reference = this.createReference(id, type, descriptor, capability);
        this.references.put(id, reference);
        return reference;
    }

    @VisibleForTesting
    DefaultCapabilityReference createReference(CapabilityIdentity id, CapabilityType type, CapabilityDescriptor descriptor, Capability capability) {
        return new DefaultCapabilityReference(this, this.eventManager, this.activationConditionHandlerFactory, this.validityConditionHandlerFactory, id, type, descriptor, capability);
    }

    private void validateId(CapabilityIdentity id) {
        if (this.get(id) == null) {
            throw new CapabilityNotFoundException(id);
        }
    }

    private Map<String, String> encryptValuesIfNeeded(CapabilityDescriptor descriptor, Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return props;
        }
        HashMap encrypted = Maps.newHashMap(props);
        List formFields = descriptor.formFields();
        if (formFields != null) {
            for (FormField formField : formFields) {
                String value;
                if (!(formField instanceof Encrypted) || (value = (String)encrypted.get(formField.getId())) == null) continue;
                try {
                    encrypted.put(formField.getId(), this.passwordHelper.encrypt(value));
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not encrypt value of '" + formField.getType() + "' due to " + e.getMessage(), e);
                }
            }
        }
        return encrypted;
    }

    private Map<String, String> decryptValuesIfNeeded(CapabilityDescriptor descriptor, Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return props;
        }
        HashMap decrypted = Maps.newHashMap(props);
        List formFields = descriptor.formFields();
        if (formFields != null) {
            for (FormField formField : formFields) {
                String value;
                if (!(formField instanceof Encrypted) || (value = (String)decrypted.get(formField.getId())) == null) continue;
                try {
                    decrypted.put(formField.getId(), this.passwordHelper.tryDecrypt(value));
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not decrypt value of '" + formField.getType() + "' due to " + e.getMessage(), e);
                }
            }
        }
        return decrypted;
    }
}

