/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityType;

@Named
@Singleton
class DefaultCapabilityDescriptorRegistry
implements CapabilityDescriptorRegistry {
    private final List<CapabilityDescriptor> descriptors;
    private final Set<CapabilityDescriptor> dynamicDescriptors;

    @Inject
    DefaultCapabilityDescriptorRegistry(List<CapabilityDescriptor> descriptors) {
        this.descriptors = (List)Preconditions.checkNotNull(descriptors);
        this.dynamicDescriptors = new CopyOnWriteArraySet<CapabilityDescriptor>();
    }

    public CapabilityDescriptorRegistry register(CapabilityDescriptor capabilityDescriptor) {
        this.dynamicDescriptors.add((CapabilityDescriptor)Preconditions.checkNotNull((Object)capabilityDescriptor));
        return this;
    }

    public CapabilityDescriptorRegistry unregister(CapabilityDescriptor capabilityDescriptor) {
        this.dynamicDescriptors.remove(Preconditions.checkNotNull((Object)capabilityDescriptor));
        return this;
    }

    public CapabilityDescriptor get(CapabilityType capabilityType) {
        CapabilityDescriptor descriptor = this.get(this.descriptors, capabilityType);
        if (descriptor == null) {
            return this.get(this.dynamicDescriptors, capabilityType);
        }
        return descriptor;
    }

    public CapabilityDescriptor[] getAll() {
        ArrayList all = Lists.newArrayList();
        all.addAll(this.descriptors);
        all.addAll(this.dynamicDescriptors);
        return all.toArray(new CapabilityDescriptor[all.size()]);
    }

    private CapabilityDescriptor get(Collection<CapabilityDescriptor> descriptors, CapabilityType capabilityType) {
        for (CapabilityDescriptor descriptor : descriptors) {
            if (!descriptor.type().equals((Object)capabilityType)) continue;
            return descriptor;
        }
        return null;
    }
}

