/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.capability;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.formfields.Encrypted;
import org.sonatype.nexus.formfields.FormField;

@Named
@Singleton
public class CapabilityAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "capability";

    public CapabilityAuditor() {
        this.registerType(CapabilityEvent.Created.class, "created");
        this.registerType(CapabilityEvent.AfterActivated.class, "activated");
        this.registerType(CapabilityEvent.BeforePassivated.class, "passivated");
        this.registerType(CapabilityEvent.AfterRemove.class, "deleted");
        this.registerType(CapabilityEvent.AfterUpdate.class, "updated");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CapabilityEvent event) {
        if (this.isRecording()) {
            CapabilityReference reference = event.getReference();
            CapabilityContext context = reference.context();
            CapabilityDescriptor descriptor = context.descriptor();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(event.getClass()));
            data.setContext(context.type().toString());
            Map attributes = data.getAttributes();
            attributes.put("id", context.id().toString());
            attributes.put("type", context.type().toString());
            attributes.put("enabled", CapabilityAuditor.string((Object)context.isEnabled()));
            attributes.put("active", CapabilityAuditor.string((Object)context.isActive()));
            attributes.put("failed", CapabilityAuditor.string((Object)context.hasFailure()));
            Map<String, FormField> fields = CapabilityAuditor.fields(descriptor);
            for (Map.Entry entry : context.properties().entrySet()) {
                FormField field = fields.get(entry.getKey());
                if (field instanceof Encrypted) continue;
                attributes.put("property." + (String)entry.getKey(), entry.getValue());
            }
            this.record(data);
        }
    }

    private static Map<String, FormField> fields(CapabilityDescriptor descriptor) {
        HashMap<String, FormField> result = new HashMap<String, FormField>();
        for (FormField field : descriptor.formFields()) {
            result.put(field.getId(), field);
        }
        return result;
    }
}

