/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.backup.orient;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.internal.backup.orient.DatabaseBackupTask;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptorSupport;

@Named
@Singleton
public class DatabaseBackupTaskDescriptor
extends TaskDescriptorSupport {
    public static final String MSG = "Admin - Export databases for backup";
    public static final String TYPE_ID = "db.backup";
    public static final String BACKUP_LOCATION = "location";
    private static final Messages messages = (Messages)I18N.create(Messages.class);

    @Inject
    public DatabaseBackupTaskDescriptor(NodeAccess nodeAccess) {
        super(TYPE_ID, DatabaseBackupTask.class, messages.name(), true, true, new FormField[]{new StringTextFormField(BACKUP_LOCATION, messages.locationLabel(), messages.locationHelpText(), true), nodeAccess.isClustered() ? DatabaseBackupTaskDescriptor.newLimitNodeFormField() : null});
    }

    public void initializeConfiguration(TaskConfiguration configuration) {
        configuration.setString("limitnode", "");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Admin - Export databases for backup")
        public String name();

        @MessageBundle.DefaultMessage(value="Backup location")
        public String locationLabel();

        @MessageBundle.DefaultMessage(value="Filesystem location for backup data")
        public String locationHelpText();
    }
}

