/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas.customizers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.log.LogManager;
import org.sonatype.nexus.supportzip.GeneratedContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;

@Named
@Singleton
public class AuditLogCustomizer
extends ComponentSupport
implements SupportBundleCustomizer {
    private final LogManager logManager;

    @Inject
    public AuditLogCustomizer(LogManager logManager) {
        this.logManager = (LogManager)Preconditions.checkNotNull((Object)logManager);
    }

    public void customize(SupportBundle supportBundle) {
        supportBundle.add((SupportBundle.ContentSource)new GeneratedContentSourceSupport(SupportBundle.ContentSource.Type.AUDITLOG, "log/audit.log", SupportBundle.ContentSource.Priority.LOW){

            protected void generate(File file) {
                try {
                    InputStream is = AuditLogCustomizer.this.logManager.getLogFileStream("audit.log", 0L, Long.MAX_VALUE);
                    if (is != null) {
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    } else {
                        this.log.debug("Not including missing audit.log file");
                    }
                }
                catch (IOException e) {
                    this.log.debug("Unable to include audit.log file", (Throwable)e);
                }
            }
        });
    }
}

