/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.atlas;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ByteSize;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.DownloadService;
import org.sonatype.nexus.internal.atlas.FlushableZipOutputStream;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.sonatype.nexus.supportzip.SupportBundleCustomizer;
import org.sonatype.nexus.supportzip.SupportZipGenerator;

@Named
@Singleton
public class SupportZipGeneratorImpl
extends ComponentSupport
implements SupportZipGenerator,
GroovyObject {
    private final List<SupportBundleCustomizer> bundleCustomizers;
    private final DownloadService downloadService;
    private final ByteSize maxFileSize;
    private final ByteSize maxZipFileSize;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Inject
    public SupportZipGeneratorImpl(DownloadService downloadService, List<SupportBundleCustomizer> bundleCustomizers, @Named(value="${atlas.supportZipGenerator.maxFileSize:-30mb}") ByteSize maxFileSize, @Named(value="${atlas.supportZipGenerator.maxZipFileSize:-20mb}") ByteSize maxZipFileSize) {
        MetaClass metaClass;
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callStatic(Preconditions.class, bundleCustomizers);
        this.bundleCustomizers = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[1].callStatic(Preconditions.class, (Object)downloadService);
        this.downloadService = (DownloadService)ScriptBytecodeAdapter.castToType((Object)object2, DownloadService.class);
        ByteSize byteSize = maxFileSize;
        this.maxFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)byteSize, ByteSize.class);
        callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Maximum included file size: {}", (Object)maxFileSize);
        ByteSize byteSize2 = maxZipFileSize;
        this.maxZipFileSize = (ByteSize)ScriptBytecodeAdapter.castToType((Object)byteSize2, ByteSize.class);
        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Maximum ZIP file size: {}", (Object)maxZipFileSize);
    }

    private Set<SupportBundle.ContentSource.Type> includedTypes(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        List types = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty((Object)request))) {
            callSiteArray[7].call((Object)types, callSiteArray[8].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty((Object)request))) {
            callSiteArray[10].call((Object)types, callSiteArray[11].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].callGetProperty((Object)request))) {
            callSiteArray[13].call((Object)types, callSiteArray[14].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callGetProperty((Object)request))) {
            callSiteArray[16].call((Object)types, callSiteArray[17].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].callGetProperty((Object)request))) {
            callSiteArray[19].call((Object)types, callSiteArray[20].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].callGetProperty((Object)request))) {
            callSiteArray[22].call((Object)types, callSiteArray[23].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].callGetProperty((Object)request))) {
            callSiteArray[25].call((Object)types, callSiteArray[26].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].callGetProperty((Object)request))) {
            callSiteArray[28].call((Object)types, callSiteArray[29].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].callGetProperty((Object)request))) {
            callSiteArray[31].call((Object)types, callSiteArray[32].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].callGetProperty((Object)request))) {
            callSiteArray[34].call((Object)types, callSiteArray[35].callGetProperty(SupportBundle.ContentSource.Type.class));
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)types, Set.class);
    }

    private List<SupportBundle.ContentSource> filterSources(SupportZipGenerator.Request request, SupportBundle supportBundle) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference include = new Reference(callSiteArray[36].callCurrent((GroovyObject)this, (Object)request));
        Reference sources = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public class _filterSources_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference include;
            private /* synthetic */ Reference sources;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _filterSources_closure1(Object _outerInstance, Object _thisObject, Reference include, Reference sources) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.include = reference2 = include;
                this.sources = reference = sources;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.include.get(), callSiteArray[1].callGetProperty(it)))) {
                    callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), (Object)"Including content source: {}", it);
                    return callSiteArray[4].call(this.sources.get(), it);
                }
                return null;
            }

            public Object getInclude() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.include.get();
            }

            public Object getSources() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.sources.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _filterSources_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filterSources_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "contains";
                stringArray[1] = "type";
                stringArray[2] = "debug";
                stringArray[3] = "log";
                stringArray[4] = "leftShift";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _filterSources_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_filterSources_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _filterSources_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[37].call(callSiteArray[38].callGetProperty((Object)supportBundle), (Object)new _filterSources_closure1((Object)this, (Object)this, include, sources));
        return (List)ScriptBytecodeAdapter.castToType((Object)sources.get(), List.class);
    }

    public SupportZipGenerator.Result generate(SupportZipGenerator.Request request) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        return (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callCurrent((GroovyObject)this, (Object)request, (Object)"support-"), SupportZipGenerator.Result.class);
    }

    public SupportZipGenerator.Result generate(SupportZipGenerator.Request request, String prefix) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        callSiteArray[40].callStatic(Preconditions.class, (Object)request);
        callSiteArray[41].call(callSiteArray[42].callGroovyObjectGetProperty((Object)this), (Object)"Generating support ZIP: {}", (Object)request);
        Object uniquePrefix = callSiteArray[43].call((Object)this.downloadService, (Object)prefix);
        Object file = callSiteArray[44].callGetProperty(callSiteArray[45].call(File.class, (Object)new GStringImpl(new Object[]{uniquePrefix}, new String[]{"", "-"}), (Object)".zip"));
        callSiteArray[46].call(callSiteArray[47].callGroovyObjectGetProperty((Object)this), (Object)"Writing ZIP file: {}", file);
        Object truncated = callSiteArray[48].callCurrent((GroovyObject)this, (Object)request, uniquePrefix, callSiteArray[49].call(file));
        Object length = callSiteArray[50].call(file);
        GStringImpl targetFileName = new GStringImpl(new Object[]{uniquePrefix}, new String[]{"", ".zip"});
        Object path = callSiteArray[51].call((Object)this.downloadService, file, (Object)targetFileName);
        callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)this), (Object)"Created support ZIP file: {}", path);
        return (SupportZipGenerator.Result)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor(SupportZipGenerator.Result.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"filename", targetFileName, "localPath", path, "size", length, "truncated", truncated})), SupportZipGenerator.Result.class);
    }

    public boolean generate(SupportZipGenerator.Request request, String prefix, OutputStream outputStream) {
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference bundle = new Reference(callSiteArray[55].callConstructor(SupportBundle.class));
        public class _generate_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bundle;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generate_closure2(Object _outerInstance, Object _thisObject, Reference bundle) {
                Reference reference;
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.bundle = reference = bundle;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Customizing bundle with: {}", it);
                return callSiteArray[2].call(it, this.bundle.get());
            }

            public Object getBundle() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.bundle.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "customize";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _generate_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[56].call(this.bundleCustomizers, (Object)new _generate_closure2((Object)this, (Object)this, bundle));
        callSiteArray[57].callStatic(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call(callSiteArray[59].callGetProperty(bundle.get()))) ? 1 : 0), (Object)"At least one bundle source must be configured");
        Object sources = callSiteArray[60].callCurrent((GroovyObject)this, (Object)request, bundle.get());
        callSiteArray[61].callStatic(Preconditions.class, (Object)(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].call(sources)) ? 1 : 0), (Object)"At least one content source must be configured");
        public class _generate_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generate_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Preparing bundle source: {}", it);
                callSiteArray[2].call(it);
                Object object = it;
                try {
                    return object;
                }
                catch (Exception e) {
                    callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Failed to prepare source {}", callSiteArray[5].callGetProperty(it), (Object)e);
                    Object var5_5 = null;
                    return var5_5;
                }
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "prepare";
                stringArray[3] = "error";
                stringArray[4] = "log";
                stringArray[5] = "class";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _generate_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object preparedSources = callSiteArray[63].call(callSiteArray[64].call(sources, (Object)new _generate_closure3((Object)this, (Object)this)));
        boolean bl = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)outputStream, (Object)preparedSources, (Object)prefix, (Object)callSiteArray[66].callGetProperty((Object)request), (Object)callSiteArray[67].callGetProperty((Object)request))));
        public class _generate_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generate_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Cleaning bundle source: {}", it);
                Object object = callSiteArray[2].call(it);
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Bundle source cleanup failed", (Object)e);
                    return object2;
                }
            }

            public Object doCall() {
                CallSite[] callSiteArray = _generate_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generate_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "debug";
                stringArray[1] = "log";
                stringArray[2] = "cleanup";
                stringArray[3] = "warn";
                stringArray[4] = "log";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _generate_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generate_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generate_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[68].call(sources, (Object)new _generate_closure4((Object)this, (Object)this));
        try {
            return bl;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].call(callSiteArray[70].callGroovyObjectGetProperty((Object)this), (Object)"Failed to create support ZIP", (Object)e));
            }
            catch (Throwable throwable) {
                callSiteArray[73].call(sources, (Object)new _generate_closure4((Object)this, (Object)this));
                throw throwable;
            }
            callSiteArray[71].call(sources, (Object)new _generate_closure4((Object)this, (Object)this));
            return bl2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean createZip(OutputStream outputStream, List<SupportBundle.ContentSource> sources, String prefix, boolean limitFileSizes, boolean limitZipSize) {
        void var3_3;
        Reference sources2 = new Reference(sources);
        Reference prefix2 = new Reference((Object)var3_3);
        Reference limitFileSizes2 = new Reference((Object)limitFileSizes);
        Reference limitZipSize2 = new Reference((Object)limitZipSize);
        CallSite[] callSiteArray = SupportZipGeneratorImpl.$getCallSiteArray();
        Reference stream = new Reference(callSiteArray[74].callConstructor(CountingOutputStream.class, (Object)outputStream));
        Reference totalUncompressed = new Reference((Object)((Long)ScriptBytecodeAdapter.castToType((Object)0, Long.class)));
        Reference zip = new Reference(callSiteArray[75].callConstructor(FlushableZipOutputStream.class, stream.get()));
        Object object = callSiteArray[76].callGetProperty(Deflater.class);
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)zip.get(), (String)"level");
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)zip.get(), (String)"syncFlush");
        public class _createZip_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createZip_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call((Object)100, callSiteArray[1].call(callSiteArray[2].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
                }
                return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call((Object)100, callSiteArray[4].call(callSiteArray[5].call((Object)compressed, (Object)uncompressed), (Object)100)), Integer.TYPE));
            }

            public Object call(long compressed, long uncompressed) {
                CallSite[] callSiteArray = _createZip_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[6].callCurrent((GroovyObject)this, (Object)compressed, (Object)uncompressed);
                }
                return this.doCall(compressed, uncompressed);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "minus";
                stringArray[1] = "multiply";
                stringArray[2] = "div";
                stringArray[3] = "minus";
                stringArray[4] = "multiply";
                stringArray[5] = "div";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _createZip_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference percentCompressed = new Reference((Object)new _createZip_closure5((Object)this, (Object)this));
        public class _createZip_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference prefix;
            private /* synthetic */ Reference zip;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createZip_closure6(Object _outerInstance, Object _thisObject, Reference prefix, Reference zip) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.prefix = reference2 = prefix;
                this.zip = reference = zip;
            }

            public Object doCall(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call((Object)path, (Object)"/"))) {
                    Object object = callSiteArray[1].call((Object)"/", (Object)path);
                    path = ShortTypeHandling.castToString((Object)object);
                }
                Object entry = callSiteArray[2].callConstructor(ZipEntry.class, callSiteArray[3].call(this.prefix.get(), (Object)path));
                callSiteArray[4].call(this.zip.get(), entry);
                return entry;
            }

            public Object call(String path) {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)path);
                }
                return this.doCall(path);
            }

            public String getPrefix() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.prefix.get());
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure6.$getCallSiteArray();
                return this.zip.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "startsWith";
                stringArray[1] = "plus";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "plus";
                stringArray[4] = "putNextEntry";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _createZip_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference addEntry = new Reference((Object)new _createZip_closure6((Object)this, (Object)this, prefix2, zip));
        public class _createZip_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference zip;
            private /* synthetic */ Reference percentCompressed;
            private /* synthetic */ Reference totalUncompressed;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createZip_closure7(Object _outerInstance, Object _thisObject, Reference zip, Reference percentCompressed, Reference totalUncompressed) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.zip = reference3 = zip;
                this.percentCompressed = reference2 = percentCompressed;
                this.totalUncompressed = reference = totalUncompressed;
            }

            public Object doCall(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                callSiteArray[0].call(this.zip.get());
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].callGetProperty((Object)entry))) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)this), (Object)"Entry (in={} out={}) bytes, compressed: {}%", callSiteArray[6].callGetProperty((Object)entry), callSiteArray[7].callGetProperty((Object)entry), callSiteArray[8].call(this.percentCompressed.get(), callSiteArray[9].callGetProperty((Object)entry), callSiteArray[10].callGetProperty((Object)entry)));
                    }
                    Object object = callSiteArray[11].call(this.totalUncompressed.get(), callSiteArray[12].callGetProperty((Object)entry));
                    this.totalUncompressed.set((Object)((Long)ScriptBytecodeAdapter.castToType((Object)object, Long.class)));
                    return object;
                }
                return null;
            }

            public Object call(ZipEntry entry) {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return callSiteArray[13].callCurrent((GroovyObject)this, (Object)entry);
            }

            public Object getZip() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.zip.get();
            }

            public Object getPercentCompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return this.percentCompressed.get();
            }

            public Long getTotalUncompressed() {
                CallSite[] callSiteArray = _createZip_closure7.$getCallSiteArray();
                return (Long)ScriptBytecodeAdapter.castToType((Object)this.totalUncompressed.get(), Long.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "closeEntry";
                stringArray[1] = "size";
                stringArray[2] = "debugEnabled";
                stringArray[3] = "log";
                stringArray[4] = "debug";
                stringArray[5] = "log";
                stringArray[6] = "size";
                stringArray[7] = "compressedSize";
                stringArray[8] = "call";
                stringArray[9] = "compressedSize";
                stringArray[10] = "size";
                stringArray[11] = "plus";
                stringArray[12] = "size";
                stringArray[13] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[14];
                _createZip_closure7.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference closeEntry = new Reference((Object)new _createZip_closure7((Object)this, (Object)this, zip, percentCompressed, totalUncompressed));
        public class _createZip_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference addEntry;
            private /* synthetic */ Reference sources;
            private /* synthetic */ Reference closeEntry;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _createZip_closure8(Object _outerInstance, Object _thisObject, Reference addEntry, Reference sources, Reference closeEntry) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.addEntry = reference3 = addEntry;
                this.sources = reference2 = sources;
                this.closeEntry = reference = closeEntry;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                callSiteArray[0].call(this.addEntry.get(), (Object)"/");
                Reference dirs = new Reference((Object)((Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
                public class _closure10
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference dirs;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure10(Object _outerInstance, Object _thisObject, Reference dirs) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.dirs = reference = dirs;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        List path = (List)ScriptBytecodeAdapter.asType((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"/"), List.class);
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[2].call((Object)path), (Object)1)) {
                            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[3].call((Object)path));
                                while (l > 1) {
                                    callSiteArray[4].call(this.dirs.get(), callSiteArray[5].call(callSiteArray[6].call((Object)path, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)ScriptBytecodeAdapter.unaryMinus((Object)l), (boolean)true)), (Object)"/"));
                                    int n = l;
                                    l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[7].call((Object)n));
                                }
                            } else {
                                int l = DefaultTypeTransformation.intUnbox((Object)callSiteArray[8].call((Object)path));
                                while (l > 1) {
                                    callSiteArray[9].call(this.dirs.get(), callSiteArray[10].call(callSiteArray[11].call((Object)path, (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)ScriptBytecodeAdapter.unaryMinus((Object)l), (boolean)true)), (Object)"/"));
                                    int n = l;
                                    int cfr_ignored_0 = n - 1;
                                }
                            }
                            return null;
                        }
                        return null;
                    }

                    public Set getDirs() {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        return (Set)ScriptBytecodeAdapter.castToType((Object)this.dirs.get(), Set.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "split";
                        stringArray[1] = "path";
                        stringArray[2] = "size";
                        stringArray[3] = "size";
                        stringArray[4] = "leftShift";
                        stringArray[5] = "join";
                        stringArray[6] = "getAt";
                        stringArray[7] = "previous";
                        stringArray[8] = "size";
                        stringArray[9] = "leftShift";
                        stringArray[10] = "join";
                        stringArray[11] = "getAt";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[12];
                        _closure10.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure10.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure10.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[1].call(this.sources.get(), (Object)new _closure10((Object)this, this.getThisObject(), dirs));
                public class _closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference addEntry;
                    private /* synthetic */ Reference closeEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure11(Object _outerInstance, Object _thisObject, Reference addEntry, Reference closeEntry) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.addEntry = reference2 = addEntry;
                        this.closeEntry = reference = closeEntry;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Adding directory entry: {}", it);
                        Object entry = callSiteArray[2].call(this.addEntry.get(), (Object)new GStringImpl(new Object[]{it}, new String[]{"", "/"}));
                        return callSiteArray[3].call(this.closeEntry.get(), entry);
                    }

                    public Object getAddEntry() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.addEntry.get();
                    }

                    public Object getCloseEntry() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.closeEntry.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "debug";
                        stringArray[1] = "log";
                        stringArray[2] = "call";
                        stringArray[3] = "call";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[4];
                        _closure11.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure11.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure11.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[2].call(callSiteArray[3].call((Object)((Set)dirs.get())), (Object)new _closure11((Object)this, this.getThisObject(), this.addEntry, this.closeEntry));
            }

            public Object getAddEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.addEntry.get();
            }

            public List getSources() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.sources.get(), List.class);
            }

            public Object getCloseEntry() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.closeEntry.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _createZip_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createZip_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "call";
                stringArray[1] = "each";
                stringArray[2] = "each";
                stringArray[3] = "sort";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _createZip_closure8.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_createZip_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _createZip_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _createZip_closure8 addDirectoryEntries = new _createZip_closure8((Object)this, (Object)this, addEntry, sources2, closeEntry);
        Reference maxContentSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call((Object)this.maxFileSize), Integer.class)));
        Reference chunkSize = new Reference((Object)0);
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[78].call((Object)4, (Object)1024);
            chunkSize.set((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)object2, Integer.class)));
        } else {
            int n = 4 * 1024;
            chunkSize.set((Object)n);
        }
        Reference maxZipSize = new Reference((Object)((Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].call(callSiteArray[80].call((Object)this.maxZipFileSize), callSiteArray[81].call((Object)DefaultTypeTransformation.intUnbox((Object)chunkSize.get()), (Object)2)), Integer.class)));
        Reference TRUNCATED_TOKEN = new Reference((Object)"** TRUNCATED **");
        Reference truncated = new Reference((Object)false);
        try {
            callSiteArray[82].call((Object)addDirectoryEntries);
            public class _createZip_closure9
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference addEntry;
                private /* synthetic */ Reference limitFileSizes;
                private /* synthetic */ Reference maxContentSize;
                private /* synthetic */ Reference zip;
                private /* synthetic */ Reference TRUNCATED_TOKEN;
                private /* synthetic */ Reference truncated;
                private /* synthetic */ Reference chunkSize;
                private /* synthetic */ Reference limitZipSize;
                private /* synthetic */ Reference stream;
                private /* synthetic */ Reference maxZipSize;
                private /* synthetic */ Reference closeEntry;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _createZip_closure9(Object _outerInstance, Object _thisObject, Reference addEntry, Reference limitFileSizes, Reference maxContentSize, Reference zip, Reference TRUNCATED_TOKEN, Reference truncated, Reference chunkSize, Reference limitZipSize, Reference stream, Reference maxZipSize, Reference closeEntry) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    Reference reference6;
                    Reference reference7;
                    Reference reference8;
                    Reference reference9;
                    Reference reference10;
                    Reference reference11;
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.addEntry = reference11 = addEntry;
                    this.limitFileSizes = reference10 = limitFileSizes;
                    this.maxContentSize = reference9 = maxContentSize;
                    this.zip = reference8 = zip;
                    this.TRUNCATED_TOKEN = reference7 = TRUNCATED_TOKEN;
                    this.truncated = reference6 = truncated;
                    this.chunkSize = reference5 = chunkSize;
                    this.limitZipSize = reference4 = limitZipSize;
                    this.stream = reference3 = stream;
                    this.maxZipSize = reference2 = maxZipSize;
                    this.closeEntry = reference = closeEntry;
                }

                public Object doCall(Object source) {
                    Reference source2 = new Reference(source);
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Adding content entry: {} {} bytes", source2.get(), callSiteArray[2].callGetProperty(source2.get()));
                    Object entry = callSiteArray[3].call(this.addEntry.get(), callSiteArray[4].callGetProperty(source2.get()));
                    try {
                        public class _closure12
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference limitFileSizes;
                            private /* synthetic */ Reference source;
                            private /* synthetic */ Reference maxContentSize;
                            private /* synthetic */ Reference zip;
                            private /* synthetic */ Reference TRUNCATED_TOKEN;
                            private /* synthetic */ Reference truncated;
                            private /* synthetic */ Reference chunkSize;
                            private /* synthetic */ Reference limitZipSize;
                            private /* synthetic */ Reference stream;
                            private /* synthetic */ Reference maxZipSize;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure12(Object _outerInstance, Object _thisObject, Reference limitFileSizes, Reference source, Reference maxContentSize, Reference zip, Reference TRUNCATED_TOKEN, Reference truncated, Reference chunkSize, Reference limitZipSize, Reference stream, Reference maxZipSize) {
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                Reference reference6;
                                Reference reference7;
                                Reference reference8;
                                Reference reference9;
                                Reference reference10;
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.limitFileSizes = reference10 = limitFileSizes;
                                this.source = reference9 = source;
                                this.maxContentSize = reference8 = maxContentSize;
                                this.zip = reference7 = zip;
                                this.TRUNCATED_TOKEN = reference6 = TRUNCATED_TOKEN;
                                this.truncated = reference5 = truncated;
                                this.chunkSize = reference4 = chunkSize;
                                this.limitZipSize = reference3 = limitZipSize;
                                this.stream = reference2 = stream;
                                this.maxZipSize = reference = maxZipSize;
                            }

                            public Object doCall(InputStream input) {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    if (DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[0].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                        callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[3].callGetProperty(this.source.get()));
                                        callSiteArray[4].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                        boolean bl = true;
                                        this.truncated.set((Object)bl);
                                        callSiteArray[5].call((Object)input, callSiteArray[6].call(callSiteArray[7].callGetProperty(this.source.get()), this.maxContentSize.get()));
                                    }
                                } else if (DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[8].callGetProperty(this.source.get()), (Object)this.maxContentSize.get())) {
                                    callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; exceeds maximum included file size: {}", callSiteArray[11].callGetProperty(this.source.get()));
                                    callSiteArray[12].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                    boolean bl = true;
                                    this.truncated.set((Object)bl);
                                    callSiteArray[13].call((Object)input, callSiteArray[14].call(callSiteArray[15].callGetProperty(this.source.get()), this.maxContentSize.get()));
                                }
                                byte[] buff = new byte[DefaultTypeTransformation.intUnbox((Object)this.chunkSize.get())];
                                int len = 0;
                                while (true) {
                                    Object object = callSiteArray[16].call((Object)input, (Object)buff);
                                    len = DefaultTypeTransformation.intUnbox((Object)object);
                                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)object, (Object)-1)) break;
                                    if (DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[17].call(callSiteArray[18].callGetProperty(this.stream.get()), (Object)len), (Object)this.maxZipSize.get())) {
                                        callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)"Truncating source contents; max ZIP size reached: {}", callSiteArray[21].callGetProperty(this.source.get()));
                                        callSiteArray[22].call(this.zip.get(), this.TRUNCATED_TOKEN.get());
                                        boolean bl = true;
                                        this.truncated.set((Object)bl);
                                        break;
                                    }
                                    callSiteArray[23].call(this.zip.get(), (Object)buff, (Object)0, (Object)len);
                                    callSiteArray[24].call(this.zip.get());
                                }
                                return null;
                            }

                            public Object call(InputStream input) {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return callSiteArray[25].callCurrent((GroovyObject)this, (Object)input);
                            }

                            public boolean getLimitFileSizes() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get());
                            }

                            public Object getSource() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return this.source.get();
                            }

                            public Integer getMaxContentSize() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                            }

                            public Object getZip() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return this.zip.get();
                            }

                            public String getTRUNCATED_TOKEN() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return ShortTypeHandling.castToString((Object)this.TRUNCATED_TOKEN.get());
                            }

                            public Boolean getTruncated() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                            }

                            public Integer getChunkSize() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                            }

                            public boolean getLimitZipSize() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get());
                            }

                            public Object getStream() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return this.stream.get();
                            }

                            public Integer getMaxZipSize() {
                                CallSite[] callSiteArray = _closure12.$getCallSiteArray();
                                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure12.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "size";
                                stringArray[1] = "warn";
                                stringArray[2] = "log";
                                stringArray[3] = "path";
                                stringArray[4] = "leftShift";
                                stringArray[5] = "skip";
                                stringArray[6] = "minus";
                                stringArray[7] = "size";
                                stringArray[8] = "size";
                                stringArray[9] = "warn";
                                stringArray[10] = "log";
                                stringArray[11] = "path";
                                stringArray[12] = "leftShift";
                                stringArray[13] = "skip";
                                stringArray[14] = "minus";
                                stringArray[15] = "size";
                                stringArray[16] = "read";
                                stringArray[17] = "plus";
                                stringArray[18] = "count";
                                stringArray[19] = "warn";
                                stringArray[20] = "log";
                                stringArray[21] = "path";
                                stringArray[22] = "leftShift";
                                stringArray[23] = "write";
                                stringArray[24] = "flush";
                                stringArray[25] = "doCall";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[26];
                                _closure12.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure12.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure12.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[5].call(callSiteArray[6].callGetProperty(source2.get()), (Object)new _closure12((Object)this, this.getThisObject(), this.limitFileSizes, source2, this.maxContentSize, this.zip, this.TRUNCATED_TOKEN, this.truncated, this.chunkSize, this.limitZipSize, this.stream, this.maxZipSize));
                    }
                    catch (Exception e) {
                        callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty((Object)this), (Object)"Unable to include {} in bundle, moving onto next file.", callSiteArray[9].callGetProperty(source2.get()), (Object)e);
                    }
                    return callSiteArray[10].call(this.closeEntry.get(), entry);
                }

                public Object getAddEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.addEntry.get();
                }

                public boolean getLimitFileSizes() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.limitFileSizes.get());
                }

                public Integer getMaxContentSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxContentSize.get(), Integer.class);
                }

                public Object getZip() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.zip.get();
                }

                public String getTRUNCATED_TOKEN() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return ShortTypeHandling.castToString((Object)this.TRUNCATED_TOKEN.get());
                }

                public Boolean getTruncated() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.truncated.get(), Boolean.class);
                }

                public Integer getChunkSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.chunkSize.get(), Integer.class);
                }

                public boolean getLimitZipSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return DefaultTypeTransformation.booleanUnbox((Object)this.limitZipSize.get());
                }

                public Object getStream() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.stream.get();
                }

                public Integer getMaxZipSize() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.maxZipSize.get(), Integer.class);
                }

                public Object getCloseEntry() {
                    CallSite[] callSiteArray = _createZip_closure9.$getCallSiteArray();
                    return this.closeEntry.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createZip_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "debug";
                    stringArray[1] = "log";
                    stringArray[2] = "size";
                    stringArray[3] = "call";
                    stringArray[4] = "path";
                    stringArray[5] = "withStream";
                    stringArray[6] = "content";
                    stringArray[7] = "warn";
                    stringArray[8] = "log";
                    stringArray[9] = "path";
                    stringArray[10] = "call";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _createZip_closure9.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_createZip_closure9.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _createZip_closure9.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[83].call(callSiteArray[84].call((Object)((List)sources2.get())), (Object)new _createZip_closure9((Object)this, (Object)this, addEntry, limitFileSizes2, maxContentSize, zip, TRUNCATED_TOKEN, truncated, chunkSize, limitZipSize2, stream, maxZipSize, closeEntry));
            if (DefaultTypeTransformation.booleanUnbox((Object)((Boolean)truncated.get()))) {
                callSiteArray[85].call(addEntry.get(), (Object)"truncated");
            }
        }
        catch (Throwable throwable) {
            callSiteArray[87].call(zip.get());
            throw throwable;
        }
        callSiteArray[86].call(zip.get());
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[88].callGetProperty(callSiteArray[89].callGroovyObjectGetProperty((Object)this)))) {
            callSiteArray[90].call(callSiteArray[91].callGroovyObjectGetProperty((Object)this), (Object)"ZIP file (in={} out={}) bytes, compressed: {}%", (Object)((Long)totalUncompressed.get()), callSiteArray[92].callGetProperty(stream.get()), callSiteArray[93].call(percentCompressed.get(), callSiteArray[94].callGetProperty(stream.get()), (Object)((Long)totalUncompressed.get())));
        }
        return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)truncated.get()));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != SupportZipGeneratorImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkNotNull";
        stringArray[1] = "checkNotNull";
        stringArray[2] = "info";
        stringArray[3] = "log";
        stringArray[4] = "info";
        stringArray[5] = "log";
        stringArray[6] = "systemInformation";
        stringArray[7] = "leftShift";
        stringArray[8] = "SYSINFO";
        stringArray[9] = "threadDump";
        stringArray[10] = "leftShift";
        stringArray[11] = "THREAD";
        stringArray[12] = "metrics";
        stringArray[13] = "leftShift";
        stringArray[14] = "METRICS";
        stringArray[15] = "configuration";
        stringArray[16] = "leftShift";
        stringArray[17] = "CONFIG";
        stringArray[18] = "security";
        stringArray[19] = "leftShift";
        stringArray[20] = "SECURITY";
        stringArray[21] = "log";
        stringArray[22] = "leftShift";
        stringArray[23] = "LOG";
        stringArray[24] = "taskLog";
        stringArray[25] = "leftShift";
        stringArray[26] = "TASKLOG";
        stringArray[27] = "auditLog";
        stringArray[28] = "leftShift";
        stringArray[29] = "AUDITLOG";
        stringArray[30] = "jmx";
        stringArray[31] = "leftShift";
        stringArray[32] = "JMX";
        stringArray[33] = "replication";
        stringArray[34] = "leftShift";
        stringArray[35] = "REPLICATIONLOG";
        stringArray[36] = "includedTypes";
        stringArray[37] = "each";
        stringArray[38] = "sources";
        stringArray[39] = "generate";
        stringArray[40] = "checkNotNull";
        stringArray[41] = "info";
        stringArray[42] = "log";
        stringArray[43] = "uniqueName";
        stringArray[44] = "canonicalFile";
        stringArray[45] = "createTempFile";
        stringArray[46] = "debug";
        stringArray[47] = "log";
        stringArray[48] = "generate";
        stringArray[49] = "newOutputStream";
        stringArray[50] = "length";
        stringArray[51] = "move";
        stringArray[52] = "info";
        stringArray[53] = "log";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "each";
        stringArray[57] = "checkState";
        stringArray[58] = "isEmpty";
        stringArray[59] = "sources";
        stringArray[60] = "filterSources";
        stringArray[61] = "checkState";
        stringArray[62] = "isEmpty";
        stringArray[63] = "findAll";
        stringArray[64] = "collect";
        stringArray[65] = "createZip";
        stringArray[66] = "limitFileSizes";
        stringArray[67] = "limitZipSize";
        stringArray[68] = "each";
        stringArray[69] = "error";
        stringArray[70] = "log";
        stringArray[71] = "each";
        stringArray[72] = "each";
        stringArray[73] = "each";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "DEFAULT_COMPRESSION";
        stringArray[77] = "toBytes";
        stringArray[78] = "multiply";
        stringArray[79] = "minus";
        stringArray[80] = "toBytes";
        stringArray[81] = "multiply";
        stringArray[82] = "call";
        stringArray[83] = "each";
        stringArray[84] = "sort";
        stringArray[85] = "call";
        stringArray[86] = "close";
        stringArray[87] = "close";
        stringArray[88] = "debugEnabled";
        stringArray[89] = "log";
        stringArray[90] = "debug";
        stringArray[91] = "log";
        stringArray[92] = "count";
        stringArray[93] = "call";
        stringArray[94] = "count";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[95];
        SupportZipGeneratorImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SupportZipGeneratorImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SupportZipGeneratorImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

