/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.UrlFormField;
import org.sonatype.nexus.internal.app.BaseUrlCapabilityConfiguration;

@Named(value="baseurl")
@Singleton
public class BaseUrlCapabilityDescriptor
extends CapabilityDescriptorSupport<BaseUrlCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "baseurl";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"baseurl");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = ImmutableList.of((Object)new UrlFormField("url", messages.urlLabel(), messages.urlHelp(), true));

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Core")});
    }

    protected BaseUrlCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new BaseUrlCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("baseurl-about.vm");
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Base URL")
        public String name();

        @MessageBundle.DefaultMessage(value="URL")
        public String urlLabel();

        @MessageBundle.DefaultMessage(value="Reverse proxy base URL")
        public String urlHelp();
    }
}

