/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.app;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.common.app.BaseUrlManager;
import org.sonatype.nexus.internal.app.BaseUrlCapabilityConfiguration;

@Named(value="baseurl")
public class BaseUrlCapability
extends CapabilitySupport<BaseUrlCapabilityConfiguration> {
    private final BaseUrlManager baseUrlManager;

    @Inject
    public BaseUrlCapability(BaseUrlManager baseUrlManager) {
        this.baseUrlManager = (BaseUrlManager)Preconditions.checkNotNull((Object)baseUrlManager);
    }

    protected BaseUrlCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new BaseUrlCapabilityConfiguration(properties);
    }

    protected void onActivate(BaseUrlCapabilityConfiguration config) throws Exception {
        this.baseUrlManager.setUrl(config.getUrl());
    }

    protected void onPassivate(BaseUrlCapabilityConfiguration config) throws Exception {
        this.baseUrlManager.setUrl(null);
    }
}

