/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.extdirect.model.StoreLoadParameters;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.security.RepositoryAdminPermission;
import org.sonatype.nexus.repository.security.RepositoryPermissionChecker;

@Named
@Singleton
@DirectAction(action={"cleanup_CleanupPolicy"})
public class CleanupPolicyComponent
extends DirectComponentSupport {
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final RepositoryManager repositoryManager;
    private final RepositoryPermissionChecker repositoryPermissionChecker;

    @Inject
    public CleanupPolicyComponent(CleanupPolicyStorage cleanupPolicyStorage, RepositoryManager repositoryManager, RepositoryPermissionChecker repositoryPermissionChecker) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryPermissionChecker = repositoryPermissionChecker;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    public List<CleanupPolicyXO> readByFormat(StoreLoadParameters parameters) {
        return Optional.ofNullable(parameters.getFilter("format")).map(format -> {
            this.ensureUserHasPermissionToCleanupPolicyByFormat((String)format);
            return format;
        }).map(this::getAllByFormat).orElse(Collections.emptyList());
    }

    private List<CleanupPolicyXO> getAllByFormat(String format) {
        return this.cleanupPolicyStorage.getAllByFormat(format).stream().map(CleanupPolicyXO::fromCleanupPolicy).collect(Collectors.toList());
    }

    private void ensureUserHasPermissionToCleanupPolicyByFormat(String format) {
        RepositoryAdminPermission permission = new RepositoryAdminPermission(format, "*", Collections.singletonList("add"));
        this.repositoryPermissionChecker.ensureUserHasAnyPermissionOrAdminAccess(Collections.singletonList(permission), "read", this.repositoryManager.browse());
    }
}

