/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class CleanupBootService
extends LifecycleSupport {
    @VisibleForTesting
    static final String CRON = "0 0 1 * * ?";
    @VisibleForTesting
    static final String TASK_NAME = "Cleanup service";
    private final TaskScheduler taskScheduler;

    @Inject
    public CleanupBootService(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() {
        this.createCleanupTask();
    }

    private void createCleanupTask() {
        if (!this.doesTaskExist()) {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("repository.cleanup");
            taskConfig.setName(TASK_NAME);
            try {
                Cron run1amEveryDay = this.taskScheduler.getScheduleFactory().cron(new Date(), CRON);
                this.taskScheduler.scheduleTask(taskConfig, (Schedule)run1amEveryDay);
            }
            catch (RuntimeException e) {
                this.log.error("Problem scheduling cleanup task", (Throwable)e);
            }
        }
        this.removeDuplicates();
    }

    private void removeDuplicates() {
        List tasks = this.taskScheduler.listsTasks().stream().filter(CleanupBootService.isCleanupTask()).filter(info -> TASK_NAME.equals(info.getConfiguration().getName())).filter(this.scheduleMatches()).collect(Collectors.toList());
        if (tasks.size() > 1) {
            tasks.subList(1, tasks.size()).forEach(TaskInfo::remove);
        }
    }

    private boolean doesTaskExist() {
        return this.taskScheduler.listsTasks().stream().anyMatch(CleanupBootService.isCleanupTask());
    }

    private static Predicate<TaskInfo> isCleanupTask() {
        return info -> "repository.cleanup".equals(info.getConfiguration().getTypeId());
    }

    private Predicate<TaskInfo> scheduleMatches() {
        Cron cron = this.taskScheduler.getScheduleFactory().cron(new Date(), CRON);
        return taskInfo -> {
            Schedule schedule = taskInfo.getSchedule();
            return schedule instanceof Cron && cron.getCronExpression().equals(((Cron)schedule).getCronExpression());
        };
    }
}

