/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Recipe;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.ConfigurationValidator;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
public class CleanupConfigurationValidator
implements ConfigurationValidator {
    private final ConstraintViolationFactory constraintViolationFactory;
    private final RepositoryManager repositoryManager;
    private final CleanupPolicyStorage cleanupPolicyStorage;

    @Inject
    public CleanupConfigurationValidator(ConstraintViolationFactory constraintViolationFactory, RepositoryManager repositoryManager, CleanupPolicyStorage cleanupPolicyStorage) {
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
    }

    @Nullable
    public ConstraintViolation<?> validate(Configuration configuration) {
        Optional<Format> format;
        List<CleanupPolicy> cleanupPolicies = this.getCleanupPolicy(configuration);
        if (!cleanupPolicies.isEmpty() && (format = this.getConfigurationFormat(configuration)).isPresent()) {
            return this.validCleanupFormat(configuration.getRepositoryName(), format.get().getValue(), cleanupPolicies.get(0));
        }
        return null;
    }

    private Optional<Format> getConfigurationFormat(Configuration configuration) {
        return this.repositoryManager.getAllSupportedRecipes().stream().filter(recipe -> configuration.getRecipeName().equals(String.valueOf(recipe.getFormat().getValue()) + "-" + recipe.getType())).map(Recipe::getFormat).findFirst();
    }

    private List<CleanupPolicy> getCleanupPolicy(Configuration configuration) {
        ArrayList<CleanupPolicy> cleanupPolicies = new ArrayList<CleanupPolicy>();
        Map attributes = configuration.getAttributes();
        if (attributes != null && attributes.containsKey("cleanup")) {
            this.addToCleanupPoliciesFromCleanupAttributes(cleanupPolicies, (Map)attributes.get("cleanup"));
        }
        return cleanupPolicies;
    }

    private void addToCleanupPoliciesFromCleanupAttributes(List<CleanupPolicy> cleanupPolicies, Map<String, Object> cleanupAttributes) {
        if (cleanupAttributes.containsKey("policyName")) {
            Collection policyNames = (Collection)cleanupAttributes.get("policyName");
            policyNames.forEach(policyName -> {
                CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get((String)policyName);
                if (Objects.nonNull(cleanupPolicy)) {
                    cleanupPolicies.add(cleanupPolicy);
                }
            });
        }
    }

    private ConstraintViolation<?> validCleanupFormat(String repoName, String repoFormat, CleanupPolicy cleanupPolicy) {
        if (!repoFormat.equals(cleanupPolicy.getFormat()) && !"ALL_FORMATS".equals(cleanupPolicy.getFormat())) {
            return this.constraintViolationFactory.createViolation("cleanup", String.format("Repository %s is of format type %s, unable to assign cleanup policy %s of format type %s", repoName, repoFormat, cleanupPolicy.getName(), cleanupPolicy.getFormat()));
        }
        return null;
    }
}

