/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.datastore.DockerRestore;
import com.sonatype.nexus.blobstore.restore.internal.datastore.DockerRestoreBlobData;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.docker.datastore.restore.DockerRepairComponent;
import org.sonatype.nexus.repository.docker.datastore.restore.DockerRestoreFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="docker")
@Singleton
public class DockerRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DockerRestoreBlobData> {
    private final Pattern dockerVersionPattern = Pattern.compile("^\\/?(?<version>v\\d+)\\/.*");
    private final DockerRepairComponent dockerRepairComponent;
    private final RepositoryManager repositoryManager;
    private final Map<String, DockerRestore> restoreVersion;

    @Inject
    protected DockerRestoreBlobStrategy(RepositoryManager repositoryManager, DryRunPrefix dryRunPrefix, Map<String, DockerRestore> restoreVersion, DockerRepairComponent dockerRepairComponent) {
        super(dryRunPrefix);
        this.restoreVersion = (Map)Preconditions.checkNotNull(restoreVersion);
        this.dockerRepairComponent = (DockerRepairComponent)Preconditions.checkNotNull((Object)dockerRepairComponent);
        this.repositoryManager = repositoryManager;
    }

    protected boolean canAttemptRestore(@Nonnull DockerRestoreBlobData data) {
        Repository repository = data.getRepository();
        Optional dockerRestoreFacet = repository.optionalFacet(DockerRestoreFacet.class);
        if (!dockerRestoreFacet.isPresent()) {
            this.log.warn("Skipping as Docker Restore Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        if (!this.restoreVersion.containsKey("v1") || !this.restoreVersion.containsKey("v2")) {
            this.log.error("Docker restoration is missing");
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob blob, DockerRestoreBlobData data) {
        String path = this.getAssetPath(data);
        String version = this.extractDockerVersionFromPath(path);
        if (this.restoreVersion.containsKey(version)) {
            this.log.info("Restoring a {} generated asset/component: {}", (Object)version, (Object)path);
            this.restoreVersion.get(version).restore(blob, data);
        } else {
            this.log.error("Unable to restore Docker version {}, blob name {}", (Object)version, (Object)path);
        }
    }

    protected String getAssetPath(@Nonnull DockerRestoreBlobData data) {
        String path = data.getBlobName();
        path = path.startsWith("/") ? path : "/" + path;
        return path;
    }

    protected DockerRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DockerRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DockerRestoreBlobData data) {
        String path = this.getAssetPath(data);
        String dockerVersion = this.extractDockerVersionFromPath(path);
        return this.restoreVersion.containsKey(dockerVersion) && this.restoreVersion.get(dockerVersion).requiresComponent(path);
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.dockerRepairComponent.updateAssets(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of docker package metadata");
        }
    }

    @VisibleForTesting
    String extractDockerVersionFromPath(String path) {
        Matcher matcher = this.dockerVersionPattern.matcher(path);
        if (matcher.matches()) {
            return matcher.group("version");
        }
        return null;
    }
}

