/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.ext.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.licensing.product.ProductLicenseManager;
import org.sonatype.licensing.product.util.LicenseContent;
import org.sonatype.licensing.product.util.LicenseFingerprinter;
import org.sonatype.nexus.common.app.ApplicationDirectories;

@Named
@Singleton
public class NexusLicenseManager
extends ComponentSupport
implements LicenseManager {
    private static final String EDITION_MARKER = "edition_pro";
    private final ProductLicenseManager licenseManager;
    private final Feature proFeature;
    private final LicenseFingerprinter licenseFingerprinter;
    private final LicenseContent licenseContent;
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public NexusLicenseManager(ProductLicenseManager licenseManager, LicenseFingerprinter licenseFingerprinter, LicenseContent licenseContent, @Named(value="NexusProfessional") Feature proFeature, ApplicationDirectories applicationDirectories) {
        this.licenseManager = (ProductLicenseManager)Preconditions.checkNotNull((Object)licenseManager);
        this.licenseFingerprinter = (LicenseFingerprinter)Preconditions.checkNotNull((Object)licenseFingerprinter);
        this.licenseContent = (LicenseContent)Preconditions.checkNotNull((Object)licenseContent);
        this.proFeature = (Feature)Preconditions.checkNotNull((Object)proFeature);
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    @Override
    public void installLicense(byte[] licenseFile) throws IOException {
        ProductLicenseKey license = this.licenseManager.getLicenseDetails((InputStream)new ByteArrayInputStream(licenseFile));
        if (!this.isLicenseApplicable(license)) {
            throw new LicensingException("Invalid license");
        }
        this.licenseManager.installLicense((InputStream)new ByteArrayInputStream(licenseFile));
        this.markEdition();
    }

    private boolean isLicenseApplicable(ProductLicenseKey licenseKey) {
        return licenseKey.getFeatureSet().hasFeature(this.proFeature);
    }

    @Override
    public void uninstallLicense() {
        this.licenseManager.uninstallLicense();
        this.unmarkEdition();
    }

    @Override
    public ProductLicenseKey getLicenseDetails() {
        return this.licenseManager.getLicenseDetails();
    }

    @Override
    public ProductLicenseKey getLicenseDetails(InputStream licenseFile) throws IOException {
        return this.licenseManager.getLicenseDetails(licenseFile);
    }

    @Override
    public String getLicenseFingerprint() {
        return this.licenseFingerprinter.calculate();
    }

    @Override
    public byte[] getLicenseFile() {
        return this.licenseContent.raw();
    }

    private File getEditionMarkerFile() {
        return this.applicationDirectories.getWorkDirectory().toPath().resolve(EDITION_MARKER).toFile();
    }

    private void markEdition() {
        File marker = this.getEditionMarkerFile();
        try {
            if (marker.createNewFile()) {
                this.log.debug("Created pro edition marker file: {}", (Object)marker);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create pro edition marker file: {}", (Object)marker, (Object)e);
        }
    }

    private void unmarkEdition() {
        File marker = this.getEditionMarkerFile();
        if (marker.delete()) {
            this.log.debug("Deleted pro edition marker file: {}", (Object)marker);
        }
    }
}

