/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.ext.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.licensing.ext.LicenseManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.product.ProductLicenseKey;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.app.ManagedLifecycle;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.KERNEL)
@Singleton
public class NexusLicenseInstaller
extends LifecycleSupport {
    private final LicenseManager licenseManager;
    private final ApplicationLicense applicationLicense;
    @Nullable
    private final File licenseFile;

    @Inject
    public NexusLicenseInstaller(LicenseManager licenseManager, ApplicationLicense applicationLicense, @Nullable @Named(value="${nexus.licenseFile}") File licenseFile) {
        this.licenseManager = (LicenseManager)Preconditions.checkNotNull((Object)licenseManager);
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
        this.licenseFile = licenseFile;
    }

    protected void doStart() throws Exception {
        if (this.licenseFile != null) {
            try {
                ProductLicenseKey existing = this.licenseManager.getLicenseDetails();
                if (existing != null) {
                    this.log.info("Ignoring property nexus.licenseFile={}. A license is already installed.", (Object)this.licenseFile);
                } else {
                    this.installLicense(this.licenseFile);
                }
            }
            catch (LicensingException e) {
                this.log.debug("caught LicensingException, indicates no license present", (Throwable)e);
                this.installLicense(this.licenseFile);
            }
        }
    }

    private void installLicense(File licenseFile) throws IOException {
        this.log.info("Installing license from property nexus.licenseFile={}", (Object)licenseFile);
        this.licenseManager.installLicense(Files.readAllBytes(licenseFile.toPath()));
        this.applicationLicense.refresh();
    }
}

