/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiCreateRequest;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiModel;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreApiUpdateRequest;
import org.sonatype.nexus.blobstore.file.rest.FileBlobStoreResourceDoc;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceUtil;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FileBlobStoreResource
extends ComponentSupport
implements Resource,
FileBlobStoreResourceDoc {
    private BlobStoreManager blobStoreManager;

    @Inject
    public FileBlobStoreResource(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:create"})
    @POST
    @Path(value="/file")
    @Validate
    public void createFileBlobStore(@Valid FileBlobStoreApiCreateRequest request) throws Exception {
        BlobStoreConfiguration configuration = request.toBlobStoreConfiguration(this.blobStoreManager.newConfiguration());
        if (this.blobStoreManager.exists(request.getName())) {
            throw new ValidationErrorsException("name", "Name is already used, must be unique (ignoring case)");
        }
        this.blobStoreManager.create(configuration);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:update"})
    @PUT
    @Path(value="/file/{name}")
    @Validate
    public void updateFileBlobStore(@PathParam(value="name") String name, @Valid FileBlobStoreApiUpdateRequest request) throws Exception {
        this.getBlobStoreConfiguration(name);
        BlobStoreConfiguration configuration = request.toBlobStoreConfiguration(this.blobStoreManager.newConfiguration());
        configuration.setName(name);
        this.blobStoreManager.update(configuration);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/file/{name}")
    public FileBlobStoreApiModel getFileBlobStoreConfiguration(@PathParam(value="name") String name) {
        BlobStoreConfiguration configuration = this.getBlobStoreConfiguration(name);
        return new FileBlobStoreApiModel(configuration);
    }

    private BlobStoreConfiguration getBlobStoreConfiguration(String name) {
        BlobStoreConfiguration configuration;
        if (!this.blobStoreManager.exists(name)) {
            BlobStoreResourceUtil.throwBlobStoreNotFoundException();
        }
        if (!(configuration = this.blobStoreManager.get(name).getBlobStoreConfiguration()).getType().equals("File")) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"Unable to read non-file blob store configuration (type was " + configuration.getType() + ")\""), "application/json");
        }
        return configuration;
    }
}

