/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.rest;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotEmpty;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiModel;

public class FileBlobStoreApiModel
extends BlobStoreApiModel {
    @ApiModelProperty(value="The path to the blobstore contents. This can be an absolute path to anywhere on the system Nexus Repository Manager has access to or it can be a path relative to the sonatype-work directory.")
    @NotEmpty(message="Path is required")
    private @NotEmpty(message="Path is required") String path;

    public FileBlobStoreApiModel() {
    }

    public FileBlobStoreApiModel(BlobStoreConfiguration configuration) {
        super(configuration);
        this.path = (String)configuration.attributes("file").get("path", String.class);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BlobStoreConfiguration toBlobStoreConfiguration(BlobStoreConfiguration configuration) {
        BlobStoreConfiguration newConfig = super.toBlobStoreConfiguration(configuration);
        newConfig.setType("File");
        newConfig.attributes("file").set("path", (Object)this.path);
        return newConfig;
    }
}

