/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal.orient;

import com.squareup.tape.QueueFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.file.FileBlobDeletionIndex;
import org.sonatype.nexus.blobstore.file.FileBlobStore;
import org.sonatype.nexus.common.property.PropertiesFile;

@Named
public class OrientFileBlobDeletionIndex
extends ComponentSupport
implements FileBlobDeletionIndex {
    private QueueFile deletedBlobIndex;

    @Override
    public final void initIndex(PropertiesFile metadata, FileBlobStore blobStore) throws IOException {
        Path storageDir = blobStore.getAbsoluteBlobDir();
        File deletedIndexFile = storageDir.resolve(blobStore.getDeletionsFilename()).toFile();
        Path deletedIndexPath = deletedIndexFile.toPath();
        try {
            Path legacyDeletionsIndex = deletedIndexPath.getParent().resolve("deletions.index");
            if (!Files.exists(deletedIndexPath, new LinkOption[0]) && Files.exists(legacyDeletionsIndex, new LinkOption[0])) {
                this.log.info("Found 'deletions.index' file in blob store {}, renaming to {}", (Object)storageDir, (Object)deletedIndexPath);
                Files.move(legacyDeletionsIndex, deletedIndexPath, new CopyOption[0]);
            }
            this.deletedBlobIndex = new QueueFile(deletedIndexFile);
        }
        catch (IOException e) {
            this.log.error("Unable to load deletions index file {}, run the compact blobstore task to rebuild", (Object)deletedIndexFile, (Object)e);
            OrientFileBlobDeletionIndex.createEmptyDeletionsIndex(deletedIndexFile);
            this.deletedBlobIndex = new QueueFile(deletedIndexFile);
            metadata.setProperty("rebuildDeletedBlobIndex", "true");
            metadata.store();
        }
    }

    private static void createEmptyDeletionsIndex(File deletionsIndex) throws IOException {
        Path tempFile = Files.createTempFile("deletions.index", "tmp", new FileAttribute[0]);
        Files.delete(tempFile);
        try {
            new QueueFile(tempFile.toFile()).close();
            Throwable throwable = null;
            Object var3_4 = null;
            try (RandomAccessFile raf = new RandomAccessFile(deletionsIndex, "rw");){
                raf.setLength(0L);
                raf.write(Files.readAllBytes(tempFile));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    @Override
    public final void stopIndex() throws IOException {
        try {
            this.deletedBlobIndex.close();
        }
        finally {
            this.deletedBlobIndex = null;
        }
    }

    @Override
    public final void createRecord(BlobId blobId) throws IOException {
        this.deletedBlobIndex.add(blobId.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public final String readOldestRecord() throws IOException {
        byte[] bytes = this.deletedBlobIndex.peek();
        if (Objects.isNull(bytes)) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public final void deleteRecord(BlobId blobId) throws IOException {
        this.deletedBlobIndex.remove();
    }

    @Override
    public final void deleteAllRecords() throws IOException {
        this.deletedBlobIndex.clear();
    }

    @Override
    public final int size() throws IOException {
        return this.deletedBlobIndex.size();
    }
}

