/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal.datastore.metrics;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.blobstore.file.FileBlobStoreMetricsService;
import org.sonatype.nexus.blobstore.metrics.DatastoreBlobStoreMetricsServiceSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
@Priority(value=0x7FFFFFFF)
public class DatastoreFileBlobStoreMetricsService
extends DatastoreBlobStoreMetricsServiceSupport
implements FileBlobStoreMetricsService {
    private Path storageDirectory;

    @Inject
    public DatastoreFileBlobStoreMetricsService(@Named(value="${nexus.blobstore.metrics.flushInterval:-2}") int metricsFlushPeriodSeconds, BlobStoreMetricsStore blobStoreMetricsStore, PeriodicJobService jobService) {
        super(metricsFlushPeriodSeconds, jobService, blobStoreMetricsStore);
    }

    public BlobStoreMetrics getMetrics() {
        BlobStoreMetricsEntity metricsEntity = this.blobStoreMetricsStore.get(this.blobStore.getBlobStoreConfiguration().getName());
        if (metricsEntity == null) {
            metricsEntity = new BlobStoreMetricsEntity();
        }
        try {
            FileStore fileStore = Files.getFileStore(this.storageDirectory);
            ImmutableMap availableSpace = ImmutableMap.of((Object)("fileStore:" + fileStore.name()), (Object)fileStore.getUsableSpace());
            return new AccumulatingBlobStoreMetrics(metricsEntity.getBlobCount(), metricsEntity.getTotalSize(), (Map)availableSpace, false);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void setStorageDir(Path storageDir) {
        this.storageDirectory = storageDir;
    }
}

