/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal.datastore;

import com.google.common.base.Preconditions;
import com.squareup.tape.QueueFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.file.FileBlobDeletionIndex;
import org.sonatype.nexus.blobstore.file.FileBlobStore;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsData;
import org.sonatype.nexus.blobstore.file.store.SoftDeletedBlobsStore;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;

@Named
public class DatastoreFileBlobDeletionIndex
extends ComponentSupport
implements FileBlobDeletionIndex {
    private final SoftDeletedBlobsStore softDeletedBlobsStore;
    private FileBlobStore blobStore;
    private String blobStoreName;
    private Queue<String> deletedRecordsCache;
    private static final int INTERVAL_IN_SECONDS = 60;

    @Inject
    public DatastoreFileBlobDeletionIndex(SoftDeletedBlobsStore softDeletedBlobsStore) {
        this.softDeletedBlobsStore = (SoftDeletedBlobsStore)Preconditions.checkNotNull((Object)softDeletedBlobsStore);
    }

    @Override
    public final void initIndex(PropertiesFile metadata, FileBlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.blobStoreName = blobStore.getBlobStoreConfiguration().getName();
        this.migrateDeletionIndexFromFileIfExists(metadata);
        this.deletedRecordsCache = new ArrayDeque<String>();
    }

    @Override
    public void stopIndex() throws IOException {
    }

    @Override
    public final void createRecord(BlobId blobId) {
        this.softDeletedBlobsStore.createRecord(blobId, this.blobStoreName);
    }

    private void populateInternalCache() {
        ArrayList<SoftDeletedBlobsData> response = new ArrayList<SoftDeletedBlobsData>();
        Continuation<SoftDeletedBlobsData> page = this.softDeletedBlobsStore.readRecords(null, this.blobStoreName);
        while (!page.isEmpty()) {
            response.addAll((Collection<SoftDeletedBlobsData>)page);
            page = this.softDeletedBlobsStore.readRecords(page.nextContinuationToken(), this.blobStoreName);
        }
        this.deletedRecordsCache.addAll(response.stream().sorted(Comparator.comparing(SoftDeletedBlobsData::getDeletedDate, Comparator.nullsLast(Comparator.naturalOrder()))).map(SoftDeletedBlobsData::getBlobId).collect(Collectors.toList()));
    }

    @Override
    public final String readOldestRecord() {
        if (this.deletedRecordsCache.isEmpty()) {
            this.populateInternalCache();
        }
        return this.deletedRecordsCache.peek();
    }

    @Override
    public final void deleteRecord(BlobId blobId) {
        this.deletedRecordsCache.remove();
        this.softDeletedBlobsStore.deleteRecord(this.blobStoreName, blobId);
    }

    @Override
    public final void deleteAllRecords() {
        this.softDeletedBlobsStore.deleteAllRecords(this.blobStoreName);
    }

    @Override
    public final int size() throws IOException {
        return this.softDeletedBlobsStore.count(this.blobStoreName);
    }

    private void migrateDeletionIndexFromFileIfExists(PropertiesFile metadata) throws IOException {
        QueueFile oldDeletionIndex;
        File oldDeletionIndexFile = this.getOldDeletionIndexFile(this.blobStore);
        if (!oldDeletionIndexFile.exists()) {
            this.log.debug("Skipping deletion file does not exist");
            return;
        }
        try {
            oldDeletionIndex = new QueueFile(oldDeletionIndexFile);
        }
        catch (IOException e) {
            this.log.error("Unable to load deletions index file {}, run the compact blobstore task to rebuild", (Object)oldDeletionIndexFile, (Object)e);
            oldDeletionIndex = null;
            metadata.setProperty("rebuildDeletedBlobIndex", "true");
            metadata.store();
        }
        if (Objects.nonNull(oldDeletionIndex) && !oldDeletionIndex.isEmpty()) {
            this.log.info("Processing blobstore {}, discovered file-based deletion index. Migrating to DB-based", (Object)this.blobStore.getBlobStoreConfiguration().getName());
            Throwable throwable = null;
            Object var5_7 = null;
            try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
                int counter = 0;
                int numBlobs = oldDeletionIndex.size();
                while (counter < numBlobs) {
                    byte[] bytes = oldDeletionIndex.peek();
                    if (bytes == null) {
                        this.log.debug("Queue indicated no more results {} of {}", (Object)counter, (Object)numBlobs);
                        break;
                    }
                    BlobId blobId = new BlobId(new String(bytes, StandardCharsets.UTF_8));
                    this.softDeletedBlobsStore.createRecord(blobId, this.blobStore.getBlobStoreConfiguration().getName());
                    oldDeletionIndex.remove();
                    progressLogger.info("Elapsed time: {}, processed: {}/{}", new Object[]{progressLogger.getElapsed(), counter + 1, numBlobs});
                    ++counter;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (oldDeletionIndexFile.exists() && !oldDeletionIndexFile.delete()) {
            this.log.error("Unable to delete 'deletion index' file, path = {}", (Object)oldDeletionIndexFile.getAbsolutePath());
        }
    }

    private File getOldDeletionIndexFile(FileBlobStore blobStore) throws IOException {
        Path blobDir = blobStore.getAbsoluteBlobDir();
        File deletedIndexFile = blobDir.resolve(blobStore.getDeletionsFilename()).toFile();
        Path deletedIndexPath = deletedIndexFile.toPath();
        Path legacyDeletionsIndex = deletedIndexPath.getParent().resolve("deletions.index");
        if (!Files.exists(deletedIndexPath, new LinkOption[0]) && Files.exists(legacyDeletionsIndex, new LinkOption[0])) {
            Files.move(legacyDeletionsIndex, deletedIndexPath, new CopyOption[0]);
        }
        return deletedIndexFile;
    }
}

