/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.BlobStoreMetricsNotAvailableException;
import org.sonatype.nexus.blobstore.BlobStoreMetricsStoreSupport;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.file.FileBlobStoreMetricsService;
import org.sonatype.nexus.blobstore.file.internal.FileOperations;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class OrientFileBlobStoreMetricsStore
extends BlobStoreMetricsStoreSupport<PropertiesFile>
implements FileBlobStoreMetricsService {
    private Path storageDirectory;
    private final FileOperations fileOperations;

    @Inject
    public OrientFileBlobStoreMetricsStore(PeriodicJobService jobService, NodeAccess nodeAccess, FileOperations fileOperations) {
        super(nodeAccess, jobService);
        this.fileOperations = (FileOperations)Preconditions.checkNotNull((Object)fileOperations);
    }

    protected PropertiesFile getProperties() {
        Path metricsDataFile = this.storageDirectory.resolve(String.valueOf(this.nodeAccess.getId()) + "-" + "metrics.properties");
        return new PropertiesFile(metricsDataFile.toFile());
    }

    protected AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics() throws BlobStoreMetricsNotAvailableException {
        try {
            FileStore fileStore = Files.getFileStore(this.storageDirectory);
            ImmutableMap availableSpace = ImmutableMap.of((Object)("fileStore:" + fileStore.name()), (Object)fileStore.getUsableSpace());
            return new AccumulatingBlobStoreMetrics(0L, 0L, (Map)availableSpace, false);
        }
        catch (IOException e) {
            throw new BlobStoreMetricsNotAvailableException((Throwable)e);
        }
    }

    public Stream<PropertiesFile> backingFiles() throws BlobStoreMetricsNotAvailableException {
        if (this.storageDirectory == null) {
            return Stream.empty();
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DirectoryStream<Path> files = Files.newDirectoryStream(this.storageDirectory, path -> path.toString().endsWith("metrics.properties"));){
                return StreamSupport.stream(files.spliterator(), false).collect(Collectors.toList()).stream().map(Path::toFile).map(PropertiesFile::new);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | SecurityException e) {
            throw new BlobStoreMetricsNotAvailableException((Throwable)e);
        }
    }

    @Override
    public void setStorageDir(Path storageDirectory) {
        Preconditions.checkNotNull((Object)storageDirectory);
        Preconditions.checkArgument((boolean)storageDirectory.toFile().isDirectory());
        this.storageDirectory = storageDirectory;
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return this.getOperationMetrics();
    }

    public void flush() throws IOException {
        super.flushProperties();
    }

    public void remove() {
        try {
            this.backingFiles().map(PropertiesFile::getFile).map(File::toPath).forEach(this.fileOperations::deleteQuietly);
        }
        catch (BlobStoreMetricsNotAvailableException e) {
            this.log.warn("Unable to remove metrics files", (Throwable)e);
        }
    }
}

