/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.file.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="File Blob Stores Path")
@Singleton
public class FileBlobStorePathValidator
extends HealthCheck {
    private static final String DUPLICATES_WARN = "A file blob store must have a unique path, and may not be contained in a sub directory of another blob store. Blob stores with violations: %s";
    private final Provider<BlobStoreManager> blobStoreManager;
    private final Provider<ApplicationDirectories> applicationDirectories;

    @Inject
    public FileBlobStorePathValidator(Provider<BlobStoreManager> blobStoreManager, Provider<ApplicationDirectories> applicationDirectories) {
        this.blobStoreManager = blobStoreManager;
        this.applicationDirectories = applicationDirectories;
    }

    @VisibleForTesting
    protected HealthCheck.Result check() throws Exception {
        Iterable blobStores = ((BlobStoreManager)this.blobStoreManager.get()).browse();
        List<BlobStoreConfiguration> configs = StreamSupport.stream(blobStores.spliterator(), false).map(BlobStore::getBlobStoreConfiguration).filter(config -> config.getType().equals("File")).collect(Collectors.toList());
        Set<BlobStoreConfiguration> pathDuplicates = this.extractPathDuplicates(configs);
        if (!pathDuplicates.isEmpty()) {
            return HealthCheck.Result.unhealthy((String)this.buildWarning(pathDuplicates));
        }
        return HealthCheck.Result.healthy();
    }

    public void validatePathUniqueConstraint(BlobStoreConfiguration configuration) {
        Path pathToCheck = this.fromBlobStoreConfiguration(configuration);
        Iterable blobStores = ((BlobStoreManager)this.blobStoreManager.get()).browse();
        List<BlobStoreConfiguration> pathDuplicates = StreamSupport.stream(blobStores.spliterator(), false).map(BlobStore::getBlobStoreConfiguration).filter(config -> config.getType().equals("File") && !config.getName().equals(configuration.getName()) && this.pathsViolateUniqueConstraint(this.fromBlobStoreConfiguration((BlobStoreConfiguration)config), pathToCheck)).collect(Collectors.toList());
        if (!pathDuplicates.isEmpty()) {
            throw new ValidationErrorsException(this.buildWarning(pathDuplicates));
        }
    }

    private Set<BlobStoreConfiguration> extractPathDuplicates(List<BlobStoreConfiguration> configs) {
        HashSet<BlobStoreConfiguration> pathDuplicates = new HashSet<BlobStoreConfiguration>();
        int i = 0;
        while (i < configs.size()) {
            BlobStoreConfiguration configI = configs.get(i);
            int k = i + 1;
            while (k < configs.size()) {
                BlobStoreConfiguration configK = configs.get(k);
                if (this.configsViolateUniquePathConstraint(configI, configK)) {
                    pathDuplicates.add(configI);
                    pathDuplicates.add(configK);
                }
                ++k;
            }
            ++i;
        }
        return pathDuplicates;
    }

    private Path fromBlobStoreConfiguration(BlobStoreConfiguration configuration) {
        return Paths.get((String)configuration.attributes("file").get("path", String.class), new String[0]);
    }

    private boolean configsViolateUniquePathConstraint(BlobStoreConfiguration config1, BlobStoreConfiguration config2) {
        return this.pathsViolateUniqueConstraint(this.fromBlobStoreConfiguration(config1), this.fromBlobStoreConfiguration(config2));
    }

    private boolean pathsViolateUniqueConstraint(Path path1, Path path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if ((path1 = path1.normalize()).equals(path2 = path2.normalize())) {
            return true;
        }
        try {
            path1 = this.toAbsolutePath(path1);
            path2 = this.toAbsolutePath(path2);
        }
        catch (IOException iOException) {
            return false;
        }
        return path1.startsWith(path2) || path2.startsWith(path1);
    }

    private Path toAbsolutePath(Path path) throws IOException {
        if (!path.isAbsolute()) {
            Path baseDir = ((ApplicationDirectories)this.applicationDirectories.get()).getWorkDirectory("blobs").toPath().toRealPath(new LinkOption[0]).normalize();
            return baseDir.resolve(path.normalize());
        }
        return path;
    }

    private String buildWarning(Collection<BlobStoreConfiguration> pathDuplicates) {
        return String.format(DUPLICATES_WARN, pathDuplicates.stream().map(BlobStoreConfiguration::getName).collect(Collectors.joining(", ")));
    }
}

