/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;

public class MultipleFailures
extends ComponentSupport {
    private final List<Throwable> failures;

    public MultipleFailures(int initialCapacity) {
        this.failures = new ArrayList<Throwable>(initialCapacity);
    }

    public MultipleFailures() {
        this.failures = new ArrayList<Throwable>();
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public void add(Throwable failure) {
        this.log.trace("Adding: {}", failure);
        this.failures.add((Throwable)Preconditions.checkNotNull((Object)failure));
    }

    public int size() {
        return this.failures.size();
    }

    public boolean isEmpty() {
        return this.failures.isEmpty();
    }

    public void maybePropagate(@Nullable String message) throws MultipleFailuresException {
        if (!this.failures.isEmpty()) {
            this.log.trace("Propagating: {}", this.failures);
            throw new MultipleFailuresException(message);
        }
    }

    public void maybePropagate() throws MultipleFailuresException {
        this.maybePropagate(null);
    }

    public class MultipleFailuresException
    extends Exception {
        private MultipleFailuresException(String message) {
            super(message);
            for (Throwable failure : MultipleFailures.this.failures) {
                this.addSuppressed(failure);
            }
        }

        public List<Throwable> getFailures() {
            return ImmutableList.copyOf((Collection)MultipleFailures.this.failures);
        }

        @Override
        public String getMessage() {
            StringBuilder buff = new StringBuilder();
            String message = super.getMessage();
            if (message != null) {
                buff.append(message).append("; ");
            }
            int size = MultipleFailures.this.failures.size();
            buff.append(size).append(" ").append(size == 1 ? "failure" : "failures");
            return buff.toString();
        }
    }
}

