/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.rest;

import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiCreateRequest;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiModel;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiResponse;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiUpdateRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

@Api(value="Blob store")
public interface GroupBlobStoreResourceDoc {
    @ApiOperation(value="Create a group blob store")
    @ApiResponses(value={@ApiResponse(code=204, message="Success"), @ApiResponse(code=403, message="Insufficient permissions")})
    public void createGroupBlobStore(GroupBlobStoreApiCreateRequest var1) throws Exception;

    @ApiOperation(value="Update a group blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Success"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    public void updateGroupBlobStore(@ApiParam(value="The name of the blob store to update") String var1, GroupBlobStoreApiUpdateRequest var2) throws Exception;

    @ApiOperation(value="Get a group blob store configuration by name")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=GroupBlobStoreApiModel.class), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    public GroupBlobStoreApiModel getGroupBlobStoreConfiguration(@ApiParam(value="The name of the group blob store") String var1);

    @Deprecated
    @ApiOperation(value="Promote a blob store to a group blob store", hidden=true)
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=GroupBlobStoreApiModel.class), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    public GroupBlobStoreApiResponse promoteBlobStoreToGroup(@ApiParam(value="The name of the group blob store") String var1);

    @ApiOperation(value="Convert a blob store to a group blob store")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=GroupBlobStoreApiModel.class), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="Blob store not found")})
    public GroupBlobStoreApiResponse convertBlobStoreToGroup(@ApiParam(value="The name of the group blob store") String var1, @ApiParam(value="A new name to the original blob store") String var2);
}

