/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiCreateRequest;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiModel;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiResponse;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreApiUpdateRequest;
import com.sonatype.nexus.blobstore.group.rest.GroupBlobStoreResourceDoc;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceUtil;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GroupBlobStoreResource
extends ComponentSupport
implements Resource,
GroupBlobStoreResourceDoc {
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreGroupService groupService;

    public GroupBlobStoreResource(BlobStoreManager blobStoreManager, BlobStoreGroupService groupService) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.groupService = (BlobStoreGroupService)Preconditions.checkNotNull((Object)groupService);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:create"})
    @POST
    @Path(value="/group")
    public void createGroupBlobStore(GroupBlobStoreApiCreateRequest request) throws Exception {
        BlobStoreConfiguration configuration = request.toBlobStoreConfiguration(this.blobStoreManager.newConfiguration());
        this.blobStoreManager.create(configuration);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:update"})
    @PUT
    @Path(value="/group/{name}")
    public void updateGroupBlobStore(@PathParam(value="name") String name, GroupBlobStoreApiUpdateRequest request) throws Exception {
        BlobStoreConfiguration configuration = request.toBlobStoreConfiguration(this.blobStoreManager.newConfiguration());
        configuration.setName(name);
        this.blobStoreManager.update(configuration);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/group/{name}")
    public GroupBlobStoreApiModel getGroupBlobStoreConfiguration(@PathParam(value="name") String name) {
        BlobStoreConfiguration configuration;
        if (!this.blobStoreManager.exists(name)) {
            BlobStoreResourceUtil.throwBlobStoreNotFoundException();
        }
        if (!(configuration = this.blobStoreManager.get(name).getBlobStoreConfiguration()).getType().equals("Group")) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"Unable to read non-group blob store configuration (type was " + configuration.getType() + ")\""), "application/json");
        }
        return new GroupBlobStoreApiModel(configuration);
    }

    @Override
    @Deprecated
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:create"})
    @POST
    @Path(value="/group/promote/{name}")
    public GroupBlobStoreApiResponse promoteBlobStoreToGroup(@PathParam(value="name") String name) {
        String originalNewName = String.valueOf(name) + "-promoted";
        return this.convertBlobStoreToGroup(name, originalNewName);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:create"})
    @POST
    @Path(value="/group/convert/{name}/{newNameForOriginal}")
    public GroupBlobStoreApiResponse convertBlobStoreToGroup(@PathParam(value="name") String name, @PathParam(value="newNameForOriginal") String newNameForOriginal) {
        if (!this.blobStoreManager.exists(name)) {
            BlobStoreResourceUtil.throwBlobStoreNotFoundException();
        }
        if (!this.blobStoreManager.isConvertable(name)) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"Blob store could not be converted to a group blob store\"", "application/json");
        }
        if (this.blobStoreManager.exists(newNameForOriginal)) {
            BlobStoreResourceUtil.throwBlobStoreBadRequestException((String)String.format("Blob store %s is already used, must be unique (ignoring case)", newNameForOriginal));
        }
        BlobStoreGroup group = this.groupService.convert(this.blobStoreManager.get(name), newNameForOriginal);
        return new GroupBlobStoreApiResponse(group.getBlobStoreConfiguration());
    }
}

