/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.group.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.group.GroupConvertValidator;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;

@Named
@Singleton
public class BlobStoreGroupConverter
extends ComponentSupport {
    private final BlobStoreManager blobStoreManager;
    private final List<GroupConvertValidator> convertValidators;

    @Inject
    public BlobStoreGroupConverter(BlobStoreManager blobStoreManager, List<GroupConvertValidator> convertValidators) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.convertValidators = (List)Preconditions.checkNotNull(convertValidators);
    }

    public BlobStoreGroup convert(BlobStore from, String newNameForOriginal) {
        BlobStoreConfiguration fromConf = from.getBlobStoreConfiguration();
        for (GroupConvertValidator validator : this.convertValidators) {
            validator.validate(fromConf);
        }
        this.blobStoreManager.validateConfiguration(fromConf, true);
        String fromOldName = fromConf.getName();
        BlobStoreConfiguration groupConf = fromConf.copy(fromOldName);
        groupConf.setType("Group");
        groupConf.attributes("group").set("members", Collections.singletonList(newNameForOriginal));
        groupConf.attributes("group").set("fillPolicy", (Object)"writeToFirst");
        BlobStoreConfiguration renamedConf = fromConf.copy(newNameForOriginal);
        try {
            this.blobStoreManager.forceDelete(fromOldName);
        }
        catch (Exception e) {
            throw new BlobStoreException(String.format("during converting to group, failed to stop existing blob store: %s", fromOldName), (Throwable)e, null);
        }
        try {
            this.blobStoreManager.create(renamedConf);
        }
        catch (Exception e) {
            BlobStoreConfiguration restoreConf = fromConf.copy(fromOldName);
            try {
                this.blobStoreManager.create(restoreConf);
            }
            catch (Exception inner) {
                this.log.error("during converting to group, existing blob: {} store was removed, but failed to be created with new configuration and failed to be resurrected", (Object)fromOldName, (Object)inner);
            }
            throw new BlobStoreException(String.format("during converting to group, failed to stop existing blob store: %s", fromOldName), (Throwable)e, null);
        }
        try {
            return (BlobStoreGroup)this.blobStoreManager.create(groupConf);
        }
        catch (Exception e) {
            try {
                this.blobStoreManager.forceDelete(newNameForOriginal);
            }
            catch (Exception inner) {
                this.log.error("during converting to group, existing blob: {} store was removed, but the creation of the new group failed, recreating the original blob store", (Object)fromOldName, (Object)inner);
            }
            BlobStoreConfiguration restoreConf = fromConf.copy(fromOldName);
            try {
                this.blobStoreManager.create(restoreConf);
            }
            catch (Exception inner) {
                this.log.error("during converting to group, existing blob: {} store was removed, but failed to be created with new configuration and failed to be resurrected", (Object)fromOldName, (Object)inner);
            }
            throw new BlobStoreException("failed to create group configuration", (Throwable)e, null);
        }
    }
}

