/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.naming.InvalidNameException;
import org.sonatype.nexus.ssl.CertificateUtil;

public class ApiCertificate {
    private long expiresOn;
    private String fingerprint;
    private String id;
    private long issuedOn;
    private String issuerCommonName;
    private String issuerOrganization;
    private String issuerOrganizationalUnit;
    private String pem;
    private String serialNumber;
    private String subjectCommonName;
    private String subjectOrganization;
    private String subjectOrganizationalUnit;

    public long getExpiresOn() {
        return this.expiresOn;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getId() {
        return this.id;
    }

    public long getIssuedOn() {
        return this.issuedOn;
    }

    public String getIssuerCommonName() {
        return this.issuerCommonName;
    }

    public String getIssuerOrganization() {
        return this.issuerOrganization;
    }

    public String getIssuerOrganizationalUnit() {
        return this.issuerOrganizationalUnit;
    }

    public String getPem() {
        return this.pem;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public String getSubjectOrganization() {
        return this.subjectOrganization;
    }

    public String getSubjectOrganizationalUnit() {
        return this.subjectOrganizationalUnit;
    }

    public void setExpiresOn(long expiresOn) {
        this.expiresOn = expiresOn;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIssuedOn(long issuedOn) {
        this.issuedOn = issuedOn;
    }

    public void setIssuerCommonName(String issuerCommonName) {
        this.issuerCommonName = issuerCommonName;
    }

    public void setIssuerOrganization(String issuerOrganization) {
        this.issuerOrganization = issuerOrganization;
    }

    public void setIssuerOrganizationalUnit(String issuerOrganizationalUnit) {
        this.issuerOrganizationalUnit = issuerOrganizationalUnit;
    }

    public void setPem(String pem) {
        this.pem = pem;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSubjectCommonName(String subjectCommonName) {
        this.subjectCommonName = subjectCommonName;
    }

    public void setSubjectOrganization(String subjectOrganization) {
        this.subjectOrganization = subjectOrganization;
    }

    public void setSubjectOrganizationalUnit(String subjectOrganizationalUnit) {
        this.subjectOrganizationalUnit = subjectOrganizationalUnit;
    }

    public static ApiCertificate convert(Certificate cert) throws InvalidNameException, CertificateEncodingException, IOException {
        ApiCertificate apiCertificate = new ApiCertificate();
        String fingerprint = CertificateUtil.calculateFingerprint(cert);
        if (cert instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)cert;
            Map<String, String> subjectRdns = CertificateUtil.getSubjectRdns(x509Certificate);
            Map<String, String> issuerRdns = CertificateUtil.getIssuerRdns(x509Certificate);
            apiCertificate.setId(fingerprint);
            apiCertificate.setPem(CertificateUtil.serializeCertificateInPEM(cert));
            apiCertificate.setFingerprint(fingerprint);
            apiCertificate.setSerialNumber(String.valueOf(x509Certificate.getSerialNumber()));
            apiCertificate.setSubjectCommonName(subjectRdns.get("CN"));
            apiCertificate.setSubjectOrganization(subjectRdns.get("O"));
            apiCertificate.setSubjectOrganizationalUnit(subjectRdns.get("OU"));
            apiCertificate.setIssuerCommonName(issuerRdns.get("CN"));
            apiCertificate.setIssuerOrganization(issuerRdns.get("O"));
            apiCertificate.setIssuerOrganizationalUnit(issuerRdns.get("OU"));
            apiCertificate.setIssuedOn(x509Certificate.getNotBefore().getTime());
            apiCertificate.setExpiresOn(x509Certificate.getNotAfter().getTime());
            return apiCertificate;
        }
        apiCertificate.setId(fingerprint);
        apiCertificate.setPem(cert.toString());
        apiCertificate.setFingerprint(fingerprint);
        return apiCertificate;
    }
}

