/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.security;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.Permission;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.plugin.internal.rest.ApiPrivilegeScript;
import org.sonatype.nexus.script.plugin.internal.rest.ApiPrivilegeScriptRequest;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPermission;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CPrivilegeBuilder;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;
import org.sonatype.nexus.security.privilege.rest.ApiPrivilegeWithActionsRequest;
import org.sonatype.nexus.security.privilege.rest.PrivilegeAction;

@Named(value="script")
@Singleton
public class ScriptPrivilegeDescriptor
extends PrivilegeDescriptorSupport<ApiPrivilegeScript, ApiPrivilegeScriptRequest>
implements GroovyObject {
    public static final String INVALID_SCRIPT = "\"Invalid script '%s' supplied.\"";
    public static final String TYPE;
    public static final String P_NAME = "name";
    public static final String P_ACTIONS = "actions";
    private static final Messages messages;
    private final List<FormField> formFields;
    private final ScriptManager scriptManager;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Inject
    public ScriptPrivilegeDescriptor(ScriptManager scriptManager) {
        super(TYPE);
        ImmutableList immutableList;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.formFields = immutableList = ImmutableList.of((Object)((FormField)new StringTextFormField(P_NAME, messages.scriptName(), messages.scriptNameHelp(), FormField.MANDATORY)), (Object)((FormField)new StringTextFormField(P_ACTIONS, messages.actions(), messages.actionsHelp(), FormField.MANDATORY)));
        Object object = Preconditions.checkNotNull((Object)scriptManager);
        this.scriptManager = (ScriptManager)ScriptBytecodeAdapter.castToType((Object)object, ScriptManager.class);
    }

    public Permission createPermission(CPrivilege privilege) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CPrivilege cPrivilege = privilege;
            valueRecorder.record((Object)cPrivilege, 8);
            if (cPrivilege != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert privilege != null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return new ScriptPermission(this.readProperty(privilege, P_NAME, PrivilegeDescriptorSupport.ALL), this.readListProperty(privilege, P_ACTIONS, PrivilegeDescriptorSupport.ALL));
    }

    public List<FormField> getFormFields() {
        return this.formFields;
    }

    public String getName() {
        return messages.name();
    }

    public static CPrivilege privilege(String name, String ... actions) {
        return new CPrivilegeBuilder().type(TYPE).id(ScriptPrivilegeDescriptor.id(name, actions)).description(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{PrivilegeDescriptorSupport.humanizeActions((String[])actions), name}, new String[]{"", " for script: ", ""}))).property(P_NAME, name).property(P_ACTIONS, actions).create();
    }

    public static String id(String name, String ... actions) {
        Preconditions.checkArgument((actions.length > 0 ? 1 : 0) != 0);
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{TYPE, name, Joiner.on((String)",").join((Object[])ScriptBytecodeAdapter.castToType((Object)actions, Object[].class))}, new String[]{"nx-", "-", "-", ""}));
    }

    public ApiPrivilegeScript createApiPrivilegeImpl(Privilege privilege) {
        return new ApiPrivilegeScript(privilege);
    }

    public void validate(ApiPrivilegeScriptRequest apiPrivilege) {
        this.validateActions(apiPrivilege, PrivilegeAction.getBreadRunActions());
        this.validateScript(apiPrivilege.getScriptName());
    }

    public void validateScript(String scriptName) {
        if (this.scriptManager.get(scriptName) == null) {
            throw (Throwable)new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)String.format(INVALID_SCRIPT, scriptName), MediaType.APPLICATION_JSON);
        }
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ScriptPrivilegeDescriptor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ScriptPrivilegeDescriptor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ScriptPrivilegeDescriptor.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ String access$0(ScriptPrivilegeDescriptor $that, String ... actions) {
        return PrivilegeDescriptorSupport.humanizeActions((String[])actions);
    }

    public static /* synthetic */ List<String> access$1(ScriptPrivilegeDescriptor $that, CPrivilege privilege, String name, String defaultValue) {
        return $that.readListProperty(privilege, name, defaultValue);
    }

    public static /* synthetic */ String access$2(ScriptPrivilegeDescriptor $that, CPrivilege privilege, String name, String defaultValue) {
        return $that.readProperty(privilege, name, defaultValue);
    }

    public static /* synthetic */ void access$3(ScriptPrivilegeDescriptor $that, ApiPrivilegeWithActionsRequest apiPrivilege, Collection<PrivilegeAction> validActions) {
        $that.validateActions(apiPrivilege, validActions);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ScriptPrivilegeDescriptor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string;
        TYPE = string = ScriptPermission.DOMAIN;
        MessageBundle messageBundle = I18N.create(Messages.class);
        messages = (Messages)ScriptBytecodeAdapter.castToType((Object)messageBundle, Messages.class);
    }

    static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Script")
        public String name();

        @MessageBundle.DefaultMessage(value="Script Name")
        public String scriptName();

        @MessageBundle.DefaultMessage(value="The name of the script")
        public String scriptNameHelp();

        @MessageBundle.DefaultMessage(value="Actions")
        public String actions();

        @MessageBundle.DefaultMessage(value="The comma-delimited list of actions")
        public String actionsHelp();
    }
}

