/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal.rest;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.script.ScriptService;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptClient;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.ScriptResultXO;
import org.sonatype.nexus.script.ScriptRunEvent;
import org.sonatype.nexus.script.ScriptXO;
import org.sonatype.nexus.script.plugin.internal.ScriptingDisabledException;
import org.sonatype.nexus.script.plugin.internal.security.ScriptPermission;
import org.sonatype.nexus.security.BreadActions;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.privilege.PrivilegeDescriptorSupport;

@Named
@Singleton
@Path(value="/v1/script")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="Script")
public class ScriptResource
extends ComponentSupport
implements ScriptClient,
Resource,
GroovyObject {
    public static final String RESOURCE_URI = "/v1/script";
    @Inject
    private ScriptManager scriptManager;
    @Inject
    private SecurityHelper securityHelper;
    @Inject
    private ScriptService scriptService;
    @Inject
    private EventManager eventManager;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ScriptResource() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="List all stored scripts")
    public List<ScriptXO> browse() {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[0].call((Object)this.securityHelper, callSiteArray[1].callStatic(ScriptResource.class, callSiteArray[2].callGetProperty(PrivilegeDescriptorSupport.class), callSiteArray[3].callGetProperty(BreadActions.class)));
        public class _browse_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _browse_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _browse_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _browse_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "convert";
                return new CallSiteArray(_browse_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _browse_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].call((Object)this.scriptManager), (Object)new _browse_closure1((Object)this, (Object)this)), List.class);
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Read stored script by name")
    @ApiResponses(value={@ApiResponse(code=404, message="No script with the specified name")})
    public ScriptXO read(@PathParam(value="name") String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[6].call((Object)this.securityHelper, callSiteArray[7].callStatic(ScriptResource.class, (Object)name, callSiteArray[8].callGetProperty(BreadActions.class)));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callStatic(ScriptResource.class, callSiteArray[10].callCurrent((GroovyObject)this, (Object)name)), ScriptXO.class);
        }
        return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callStatic(ScriptResource.class, (Object)this.findOr404(name)), ScriptXO.class);
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Update stored script by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was updated"), @ApiResponse(code=404, message="No script with the specified name"), @ApiResponse(code=410, message="Script updating is disabled")})
    public void edit(@PathParam(value="name") String name, @NotNull @Valid ScriptXO scriptXO) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[12].call((Object)this.securityHelper, callSiteArray[13].callStatic(ScriptResource.class, (Object)name, callSiteArray[14].callGetProperty(BreadActions.class)));
        callSiteArray[15].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)name, (Object)callSiteArray[16].callGroovyObjectGetProperty((Object)scriptXO)), (Object)new GStringImpl(new Object[]{name, callSiteArray[17].callGroovyObjectGetProperty((Object)scriptXO)}, new String[]{"Path parameter: ", " does not match data name: ", ""}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[18].callCurrent((GroovyObject)this, (Object)name);
        } else {
            this.findOr404(name);
        }
        callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)"Updating Script named: {}", (Object)name);
        try {
            callSiteArray[21].call((Object)this.scriptManager, (Object)name, callSiteArray[22].callGroovyObjectGetProperty((Object)scriptXO));
        }
        catch (ScriptingDisabledException e) {
            callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)"Failed to update script {}, creating and updating scripts is disabled", (Object)name, (Object)e);
            throw (Throwable)callSiteArray[25].callConstructor(WebApplicationException.class, callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(Response.class, callSiteArray[29].callGetProperty(Response.Status.class)), callSiteArray[30].callConstructor(ScriptResultXO.class, (Object)name, callSiteArray[31].callGetProperty((Object)e)))));
        }
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Add a new script")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was added"), @ApiResponse(code=410, message="Script creation is disabled")})
    public void add(@NotNull @Valid ScriptXO scriptXO) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[32].call((Object)this.securityHelper, callSiteArray[33].callStatic(ScriptResource.class, callSiteArray[34].callGetProperty(PrivilegeDescriptorSupport.class), callSiteArray[35].callGetProperty(BreadActions.class)));
        callSiteArray[36].call(callSiteArray[37].callGroovyObjectGetProperty((Object)this), (Object)"Adding Script named: {}", callSiteArray[38].callGroovyObjectGetProperty((Object)scriptXO));
        try {
            callSiteArray[39].call((Object)this.scriptManager, callSiteArray[40].callGroovyObjectGetProperty((Object)scriptXO), callSiteArray[41].callGroovyObjectGetProperty((Object)scriptXO), callSiteArray[42].callGroovyObjectGetProperty((Object)scriptXO));
        }
        catch (ScriptingDisabledException e) {
            callSiteArray[43].call(callSiteArray[44].callGroovyObjectGetProperty((Object)this), (Object)"Failed to create script {}, creating and updating scripts is disabled", callSiteArray[45].callGroovyObjectGetProperty((Object)scriptXO), (Object)e);
            throw (Throwable)callSiteArray[46].callConstructor(WebApplicationException.class, callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(Response.class, callSiteArray[50].callGetProperty(Response.Status.class)), callSiteArray[51].callConstructor(ScriptResultXO.class, callSiteArray[52].callGroovyObjectGetProperty((Object)scriptXO), callSiteArray[53].callGetProperty((Object)e)))));
        }
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Delete stored script by name")
    @ApiResponses(value={@ApiResponse(code=204, message="Script was deleted"), @ApiResponse(code=404, message="No script with the specified name")})
    public void delete(@PathParam(value="name") String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[54].call((Object)this.securityHelper, callSiteArray[55].callStatic(ScriptResource.class, (Object)name, callSiteArray[56].callGetProperty(BreadActions.class)));
        callSiteArray[57].call(callSiteArray[58].callGroovyObjectGetProperty((Object)this), (Object)"Deleting Script named: {}", (Object)name);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[59].call((Object)this.scriptManager, callSiteArray[60].callGetProperty(callSiteArray[61].callCurrent((GroovyObject)this, (Object)name)));
        } else {
            callSiteArray[62].call((Object)this.scriptManager, callSiteArray[63].callGetProperty((Object)this.findOr404(name)));
        }
    }

    @Timed
    @ExceptionMetered
    @ApiOperation(value="Run stored script by name")
    @ApiResponses(value={@ApiResponse(code=404, message="No script with the specified name"), @ApiResponse(code=500, message="Script execution failed with exception")})
    public ScriptResultXO run(@PathParam(value="name") String name, String args) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        callSiteArray[64].call((Object)this.securityHelper, callSiteArray[65].callStatic(ScriptResource.class, (Object)name, callSiteArray[66].callGroovyObjectGetProperty((Object)this)));
        callSiteArray[67].call(callSiteArray[68].callGroovyObjectGetProperty((Object)this), (Object)"Running Script named: {}", (Object)name);
        Script script = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[69].callCurrent((GroovyObject)this, (Object)name);
            script = (Script)ScriptBytecodeAdapter.castToType((Object)object, Script.class);
        } else {
            Script script2;
            script = script2 = this.findOr404(name);
        }
        Object result = null;
        try {
            Object object;
            result = object = callSiteArray[70].call((Object)this.scriptService, callSiteArray[71].callGetProperty((Object)script), callSiteArray[72].callGetProperty((Object)script), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"log", callSiteArray[73].call(LoggerFactory.class, callSiteArray[74].callCurrent((GroovyObject)this)), "args", callSiteArray[75].callSafe((Object)args), "scriptName", callSiteArray[76].callGetProperty((Object)script)}));
            callSiteArray[77].call((Object)this.eventManager, callSiteArray[78].callConstructor(ScriptRunEvent.class, (Object)script));
        }
        catch (Exception e) {
            callSiteArray[79].call(callSiteArray[80].callGroovyObjectGetProperty((Object)this), (Object)"Exception in script execution for script named: {}", (Object)name, (Object)e);
            throw (Throwable)callSiteArray[81].callConstructor(WebApplicationException.class, callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].call(Response.class, callSiteArray[85].callGetProperty(Response.Status.class)), callSiteArray[86].callConstructor(ScriptResultXO.class, callSiteArray[87].callGetProperty((Object)script), callSiteArray[88].callGetProperty((Object)e)))));
        }
        callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty((Object)this), (Object)"Result: {}", result);
        return (ScriptResultXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].callConstructor(ScriptResultXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", name, "result", callSiteArray[92].call(result)})), ScriptResultXO.class);
    }

    private Script findOr404(String name) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        Script script = (Script)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call((Object)this.scriptManager, (Object)name), Script.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)script)) {
            throw (Throwable)callSiteArray[94].callConstructor(NotFoundException.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Script with name: '", "' not found"}));
        }
        return script;
    }

    public static ScriptXO convert(Script script) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        return (ScriptXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[95].callConstructor(ScriptXO.class, callSiteArray[96].callGetProperty((Object)script), callSiteArray[97].callGetProperty((Object)script), callSiteArray[98].callGetProperty((Object)script)), ScriptXO.class);
    }

    public static ScriptPermission scriptPermission(String name, String action) {
        CallSite[] callSiteArray = ScriptResource.$getCallSiteArray();
        return (ScriptPermission)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callConstructor(ScriptPermission.class, (Object)name, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{action})), ScriptPermission.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ScriptResource.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public void setScriptManager(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "ensurePermitted";
        stringArray[1] = "scriptPermission";
        stringArray[2] = "ALL";
        stringArray[3] = "BROWSE";
        stringArray[4] = "collect";
        stringArray[5] = "browse";
        stringArray[6] = "ensurePermitted";
        stringArray[7] = "scriptPermission";
        stringArray[8] = "READ";
        stringArray[9] = "convert";
        stringArray[10] = "findOr404";
        stringArray[11] = "convert";
        stringArray[12] = "ensurePermitted";
        stringArray[13] = "scriptPermission";
        stringArray[14] = "EDIT";
        stringArray[15] = "checkArgument";
        stringArray[16] = "name";
        stringArray[17] = "name";
        stringArray[18] = "findOr404";
        stringArray[19] = "debug";
        stringArray[20] = "log";
        stringArray[21] = "update";
        stringArray[22] = "content";
        stringArray[23] = "debug";
        stringArray[24] = "log";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "build";
        stringArray[27] = "entity";
        stringArray[28] = "status";
        stringArray[29] = "GONE";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "message";
        stringArray[32] = "ensurePermitted";
        stringArray[33] = "scriptPermission";
        stringArray[34] = "ALL";
        stringArray[35] = "ADD";
        stringArray[36] = "debug";
        stringArray[37] = "log";
        stringArray[38] = "name";
        stringArray[39] = "create";
        stringArray[40] = "name";
        stringArray[41] = "content";
        stringArray[42] = "type";
        stringArray[43] = "debug";
        stringArray[44] = "log";
        stringArray[45] = "name";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "build";
        stringArray[48] = "entity";
        stringArray[49] = "status";
        stringArray[50] = "GONE";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "name";
        stringArray[53] = "message";
        stringArray[54] = "ensurePermitted";
        stringArray[55] = "scriptPermission";
        stringArray[56] = "DELETE";
        stringArray[57] = "debug";
        stringArray[58] = "log";
        stringArray[59] = "delete";
        stringArray[60] = "name";
        stringArray[61] = "findOr404";
        stringArray[62] = "delete";
        stringArray[63] = "name";
        stringArray[64] = "ensurePermitted";
        stringArray[65] = "scriptPermission";
        stringArray[66] = "RUN_ACTION";
        stringArray[67] = "debug";
        stringArray[68] = "log";
        stringArray[69] = "findOr404";
        stringArray[70] = "eval";
        stringArray[71] = "type";
        stringArray[72] = "content";
        stringArray[73] = "getLogger";
        stringArray[74] = "getClass";
        stringArray[75] = "trim";
        stringArray[76] = "name";
        stringArray[77] = "post";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "error";
        stringArray[80] = "log";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "build";
        stringArray[83] = "entity";
        stringArray[84] = "status";
        stringArray[85] = "BAD_REQUEST";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "name";
        stringArray[88] = "message";
        stringArray[89] = "trace";
        stringArray[90] = "log";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "toString";
        stringArray[93] = "get";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "name";
        stringArray[97] = "content";
        stringArray[98] = "type";
        stringArray[99] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[100];
        ScriptResource.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ScriptResource.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ScriptResource.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

