/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.plugin.internal.ScriptDAO;
import org.sonatype.nexus.script.plugin.internal.ScriptData;
import org.sonatype.nexus.script.plugin.internal.ScriptStore;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class ScriptStoreImpl
extends ConfigStoreSupport<ScriptDAO>
implements ScriptStore {
    @Inject
    public ScriptStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    public Script newScript() {
        return new ScriptData();
    }

    @Override
    @Transactional
    public List<Script> list() {
        return ImmutableList.copyOf((Iterable)((ScriptDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public Script get(String name) {
        return ((ScriptDAO)this.dao()).read(name).orElse(null);
    }

    @Override
    @Transactional
    public void create(Script script) {
        ((ScriptDAO)this.dao()).create((ScriptData)script);
    }

    @Override
    @Transactional
    public void update(Script script) {
        ((ScriptDAO)this.dao()).update((ScriptData)script);
    }

    @Override
    @Transactional
    public void delete(Script script) {
        ((ScriptDAO)this.dao()).delete(script.getName());
    }
}

