/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.script.plugin.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptCreatedEvent;
import org.sonatype.nexus.script.ScriptDeletedEvent;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.ScriptUpdatedEvent;
import org.sonatype.nexus.script.plugin.internal.ScriptStore;
import org.sonatype.nexus.script.plugin.internal.ScriptingDisabledException;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ScriptManagerImpl
extends StateGuardLifecycleSupport
implements ScriptManager {
    private final EventManager eventManager;
    private final ScriptStore scriptStore;
    private final boolean allowCreation;

    @Inject
    public ScriptManagerImpl(EventManager eventManager, ScriptStore scriptStore, @Named(value="${nexus.scripts.allowCreation:-false}") boolean allowCreation) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.scriptStore = (ScriptStore)Preconditions.checkNotNull((Object)scriptStore);
        this.allowCreation = (Boolean)Preconditions.checkNotNull((Object)allowCreation);
    }

    @Guarded(by={"STARTED"})
    public Iterable<Script> browse() {
        return ImmutableList.copyOf(this.scriptStore.list());
    }

    @Guarded(by={"STARTED"})
    public Script get(String name) {
        return this.scriptStore.get(name);
    }

    @Guarded(by={"STARTED"})
    public Script create(String name, String content, String type) {
        this.validateCreationIsAllowed();
        Script script = this.scriptStore.newScript();
        script.setName(name);
        script.setContent(content);
        script.setType(type);
        this.scriptStore.create(script);
        this.eventManager.post((Object)new ScriptCreatedEvent(script));
        return script;
    }

    @Guarded(by={"STARTED"})
    public Script update(String name, String content) {
        this.validateCreationIsAllowed();
        Script script = this.scriptStore.get(name);
        if (script == null) {
            return null;
        }
        script.setContent(content);
        this.scriptStore.update(script);
        this.eventManager.post((Object)new ScriptUpdatedEvent(script));
        return script;
    }

    @Guarded(by={"STARTED"})
    public void delete(String name) {
        Script script = this.scriptStore.get(name);
        if (script != null) {
            this.scriptStore.delete(script);
            this.eventManager.post((Object)new ScriptDeletedEvent(script));
        }
    }

    public boolean isEnabled() {
        return this.allowCreation;
    }

    private void validateCreationIsAllowed() {
        if (!this.allowCreation) {
            throw new ScriptingDisabledException("Creating and updating scripts is disable");
        }
    }
}

