/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.jdbc;

import java.util.regex.Pattern;

public class OrientJdbcUtils {
    public static boolean like(String str, String expr) {
        String regex = OrientJdbcUtils.quotemeta(expr);
        regex = regex.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(str).matches();
    }

    public static String quotemeta(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("[](){}.*+?$^|#\\".indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getSqlTypeName(int type) {
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "?";
    }
}

