/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import com.sonatype.insight.scan.model.ArtifactId;
import com.sonatype.insight.scan.model.ItemContentType;
import com.sonatype.insight.scan.model.ScanItemProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScanItem
implements ScanItemProvider,
Serializable {
    private static final long serialVersionUID = 4088105852505240622L;
    private static final int SHA1_CHAR_SIZE = 20;
    private String path;
    private String noPathReason;
    private String nameSha1;
    private ItemContentType contentType;
    private String content;
    private Long size;
    private Long lastModified;
    private String sha1;
    private String sha1JA001;
    private String sha1JB001;
    private String sha1JC001;
    private String sha1JD001;
    private String sha1KA001;
    private String[] sha1KB001;
    private String[] sha1KC001;
    private String[] sha1KD001;
    private String sha1LA001;
    private String[] sha1LB001;
    private String[] sha1LC001;
    private String[] sha1LD001;
    private String sha512;
    private Long lastAccess;
    private String id;
    private String kind;
    private List<ArtifactId> ids;
    private Boolean hasError = null;
    private Boolean proprietary = null;
    private Boolean dependency;
    private String dailyDownloadCounts;
    private String monthlyDownloadCounts;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.size != null ? this.size : -1L;
    }

    public void setSize(long size) {
        this.size = size < 0L ? null : Long.valueOf(size);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<ArtifactId> getIds() {
        if (this.ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ids);
    }

    public void addId(ArtifactId id) {
        if (id != null) {
            if (this.ids == null) {
                this.ids = new ArrayList<ArtifactId>();
            }
            this.ids.add(id);
        }
    }

    @Override
    public List<? extends ScanItem> getItems() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getPath() + ", " + this.getSize() + ", sha1:" + this.getSha1();
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        if (sha1 != null && sha1.length() > 20) {
            sha1 = sha1.substring(0, 20);
        }
        this.sha1 = sha1;
    }

    public String getSha1JA001() {
        return this.sha1JA001;
    }

    public void setSha1JA001(String sha1ja001) {
        this.sha1JA001 = sha1ja001;
    }

    public String getSha1JB001() {
        return this.sha1JB001;
    }

    public void setSha1JB001(String sha1jb001) {
        this.sha1JB001 = sha1jb001;
    }

    public String getSha1JC001() {
        return this.sha1JC001;
    }

    public void setSha1JC001(String sha1jc001) {
        this.sha1JC001 = sha1jc001;
    }

    public String getSha1JD001() {
        return this.sha1JD001;
    }

    public void setSha1JD001(String sha1jd001) {
        this.sha1JD001 = sha1jd001;
    }

    public String getSha1KA001() {
        return this.sha1KA001;
    }

    public void setSha1KA001(String sha1ka001) {
        this.sha1KA001 = sha1ka001;
    }

    public String[] getSha1KB001() {
        return this.sha1KB001;
    }

    public void setSha1KB001(String[] sha1kb001) {
        this.sha1KB001 = sha1kb001;
    }

    public String[] getSha1KC001() {
        return this.sha1KC001;
    }

    public void setSha1KC001(String[] sha1kc001) {
        this.sha1KC001 = sha1kc001;
    }

    public String[] getSha1KD001() {
        return this.sha1KD001;
    }

    public void setSha1KD001(String[] sha1kd001) {
        this.sha1KD001 = sha1kd001;
    }

    public String getSha1LA001() {
        return this.sha1LA001;
    }

    public void setSha1LA001(String sha1la001) {
        this.sha1LA001 = sha1la001;
    }

    public String[] getSha1LB001() {
        return this.sha1LB001;
    }

    public void setSha1LB001(String[] sha1lb001) {
        this.sha1LB001 = sha1lb001;
    }

    public String[] getSha1LC001() {
        return this.sha1LC001;
    }

    public void setSha1LC001(String[] sha1lc001) {
        this.sha1LC001 = sha1lc001;
    }

    public String[] getSha1LD001() {
        return this.sha1LD001;
    }

    public void setSha1LD001(String[] sha1ld001) {
        this.sha1LD001 = sha1ld001;
    }

    public long getLastAccess() {
        return this.lastAccess != null ? this.lastAccess : 0L;
    }

    public void setLastAccess(long lastAccess) {
        this.lastAccess = lastAccess != 0L ? Long.valueOf(lastAccess) : null;
    }

    public void setHasError() {
        this.hasError = true;
    }

    public Boolean getHasError() {
        return this.hasError;
    }

    public String getNameSha1() {
        return this.nameSha1;
    }

    public void setNameSha1(String nameSha1) {
        if (nameSha1 != null && nameSha1.length() > 20) {
            nameSha1 = nameSha1.substring(0, 20);
        }
        this.nameSha1 = nameSha1;
    }

    public String getNoPathReason() {
        return this.noPathReason;
    }

    public void setNoPathReason(String noPathReason) {
        this.noPathReason = noPathReason;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified > 0L ? Long.valueOf(lastModified) : null;
    }

    public Boolean isProprietary() {
        return this.proprietary;
    }

    public void setProprietary(Boolean proprietary) {
        this.proprietary = proprietary;
    }

    public boolean isDependency() {
        return Boolean.TRUE.equals(this.dependency);
    }

    public void setDependency(boolean dependency) {
        this.dependency = dependency ? Boolean.TRUE : null;
    }

    public String getDailyDownloadCounts() {
        return this.dailyDownloadCounts;
    }

    public void setDailyDownloadCounts(String dailyDownloadCounts) {
        this.dailyDownloadCounts = dailyDownloadCounts;
    }

    public String getMonthlyDownloadCounts() {
        return this.monthlyDownloadCounts;
    }

    public void setMonthlyDownloadCounts(String monthlyDownloadCounts) {
        this.monthlyDownloadCounts = monthlyDownloadCounts;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ItemContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ItemContentType contentType) {
        this.contentType = contentType;
    }

    public String getSha512() {
        return this.sha512;
    }

    public void setSha512(String sha512) {
        this.sha512 = sha512;
    }
}

